/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ************************************************************************/

package com.adobe.granite.socketio;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.sling.commons.json.JSONArray;

import org.osgi.annotation.versioning.ConsumerType;

/**
* Socket.IO Socket listener.
*/
@ConsumerType
public interface SocketIOSocketListener {

    /**
     * Called when a socket receives an event.
     *
     * The {@code ack} parameter is not-null if the client requested an 'ack' event.
     * the listener should send the ack as soon as possible.
     *
     * @param name name of the event.
     * @param data event arguments
     * @param ack not {@code null} if the client requested an ack.
     */
    void onEvent(@Nonnull String name, @Nonnull JSONArray data, @Nullable SocketIOAck ack);

    /**
     * Called when a socket disconnects.
     *
     * @param reason informative reason
     */
    void onDisconnect(String reason);

    /**
     * Called when an error occurred
     *
     * @param data error arguments
     */
    void onError(JSONArray data);
}