/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.taskmanagement;

/**
 * The TaskManagerFactory interface defines methods to instantiate various classes for TaskManager.
 */
public interface TaskManagerFactory {
    /**
     * Creates a new task instance with the given task type name.
     * @param taskTypeName String containing the name of the type of task to create.
     * @return Task instance of the given type.
     * @throws TaskManagerException An error creating the new task instance.
     */
    Task newTask(String taskTypeName) throws TaskManagerException;

    /**
     * Creates a new TaskAction instance with the given action Id.
     * @param taskActionId the id for this task action
     * @return a TaskAction object.
     */
    TaskAction newTaskAction(String taskActionId);
}
