/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.threaddump;

import java.io.IOException;
import java.io.OutputStream;

import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface ThreadDumpsFileManager {

    /**
     * Enlists all the directories/zip files under the <code>${sling.home}/threaddumps</code> directory.
     * Each directory/zip file is in the <code>yyyyMMdd</code> pattern.
     *
     * @return all the directories/zip files under the <code>${sling.home}/threaddumps</code> directory.
     */
    String[] getThreadDumpsBackupsDirectories();

    /**
     * Compresses in the target output stream, using the Zip algorithm, all the selected directories/zip files.
     *
     * @param target the output stream where the dumps will be stored using the Zip algorithm.
     * @param selected the selected directories/zip files that have to be compressed.
     * @throws IOException if any error occurs while compressing data to the target stream.
     */
    void compressThreadDumps(OutputStream target, String...selected) throws IOException;

}
