/*************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe
 *  All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.ui.clientlibs;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ProviderType;
import com.adobe.granite.ui.clientlibs.script.ScriptProcessor;

/**
 * <code>ProcessorProvider</code>...
 */
@ProviderType
public interface ProcessorProvider {

    /**
     * Returns the processor for the given name.
     * @param name name of the processor
     * @return the processor or {@code null}
     */
    @CheckForNull
    ScriptProcessor getProcessor(@Nonnull String name);

}