/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2013 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.ds;

import java.util.Collections;
import java.util.Iterator;

import javax.annotation.Nonnull;

import org.apache.sling.api.resource.Resource;

/**
 * Abstract class that implements the {@link DataSource} interface.
 *
 * Implementor of {@link DataSource} is encouraged to extend this class to
 * ensure to always be able to support new methods that might be introduced in
 * the {@link DataSource} in the future.
 *
 * Note that since Java 8, using abstract class to solve the above scenario is
 * no longer relevant. Instead, Java 8's default methods can be used.
 */
public abstract class AbstractDataSource implements DataSource {

    @SuppressWarnings("null")
    @Override
    @Nonnull
    public Iterator<Resource> iterator() {
        return Collections.emptyIterator();
    }
}
