/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.model.WorkflowNode;
import com.adobe.granite.workflow.model.WorkflowTransition;

import java.util.List;

/**
 * <code>Route</code> represents the possible next destinations which will be
 * selectable after a {@link WorkItem} is completed.
 */
public interface Route {
	/**
	 * Returns a unique ID for the route. This ID must be unique across all
	 * routes that are returned from
	 * <code>{@link WorkflowSession#getRoutes(WorkItem, boolean)} )}</code>.
	 * 
	 * @return The ID of the route.
	 */
	String getId();

	/**
	 * Returns the a user friendly name for the route.
	 * 
	 * @return The name of the route.
	 */
	String getName();

	/**
	 * Indicates if one the <code>Route</code>s {@link WorkflowTransition}s
	 * is marked as default.
	 * 
	 * @return True if one {@link WorkflowTransition} is marked as default,
	 *         otherwise false.
	 */
	boolean hasDefault();

	/**
	 * Returns the list of possible destinations.
	 * 
	 * @return List of {@link WorkflowTransition}s that lead selectable
	 *         {@link WorkflowNode}s.
	 */
	List<WorkflowTransition> getDestinations();

	/**
	 * Returns true if the route defines to a {@link WorkflowNode} which has
	 * already been passed.
	 * 
	 * @return <code>true</code> if it is a "back" route otherwise
	 *         <code>false</code>
	 */
	boolean isBackRoute();
}
