/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec;

import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.adobe.granite.workflow.model.WorkflowNode;

/**
 * <code>WorkflowProcess</code> is the interface to be used for automatic
 * workflow steps implemented in Java. Classes implementing this interface
 * define Java based processes that can be attached to a {@link WorkflowNode}
 * and executed by the workflow engine.
 */
public interface WorkflowProcess {
    /**
     * Executes a new Java process with the given <code>{@link WorkItem}</code>
     * and <code>{@link com.adobe.granite.workflow.WorkflowSession}</code>.
     * 
     * @param item
     *            The <code>{@link WorkItem}</code> that defines the newly
     *            started <code>JavaProcessNew</code>.
     * @param session
     *            The <code>{@link com.adobe.granite.workflow.WorkflowSession}</code>
     *            that is used for starting the <code>WorkflowProcess</code>.
     * @param args
     *            Process specific arguments can be passed here
     * @throws WorkflowException
     *             Thrown in case something goes wrong during execution.
     */
    void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException;
}
