package com.adobe.internal.io;

import java.io.File;
import java.io.IOException;
/**
 * An implementation of the ByteReader interface that provides lazy access to a 
 * {@link java.io.RandomAccessFile RandomAccessFile}.  It will not open the
 * {@link java.io.File File} until the first attempt to read or operate on that 
 * {@link java.io.File File}.  At that point a 
 * {@link com.adobe.internal.io.RandomAccessFileByteReader RandomAccessFileByteReader}
 * will be constructed and used.
 * 
 * This class is <b>not</b> threadsafe.  It is not safe to pass an instance of this class
 * to multiple threads.  It is not safe to pass an instance of this class to multiple users even
 * if in the same thread.
 */
public class LazyRandomAccessFileByteReader extends ByteReaderWrapperImpl
{
	
	/**
	 * @param file
	 * @throws IOException
	 */
	public LazyRandomAccessFileByteReader(File file) throws IOException 
	{
		super(new LazyRandomAccessFileByteWriter(file));
	}
}
