/**
 * 
 */
package com.adobe.internal.io;

import java.io.IOException;
import java.io.OutputStream;

/**
 * An <code>OutputStream</code> that eats all output.
 *
 */
public class NullOutputStream extends OutputStream
{
	/**
	 * Constructor.
	 */
	public NullOutputStream()
	{
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(int)
	 */
	public void write(int b) throws IOException
	{
		// NOP
	}

	/* (non-Javadoc)
	 * @see java.io.OutputStream#write(byte[], int, int)
	 */
	public void write(byte[] b, int off, int len) throws IOException
	{
		// NOP
	}

}
