/*
 * File: PDFRuntimeException.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.internal.pdftoolkit.core.exceptions;

/**
 * This is the base class of all runtime exceptions that are thrown from Gibson.
 * Inside our code this exception should be thrown, instead of creating instances
 * of RuntimeException.
 * @author hraghav
 */
public class PDFRuntimeException extends RuntimeException
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 5130968669163679573L;
	
	/**
	 * Default constructor.
	 * This is made private to prevent creating an instance of this exception
	 * without an error message or exception.
	 */
	@SuppressWarnings("unused")
	private PDFRuntimeException()
	{
		
	}
	
	/**
	 * Constructor with a string message 
	 */
	public PDFRuntimeException(String message)
	{
		super(message);
	}
	
	/**
	 * Creates a PDFRuntimeException by wrapping a PDFException
	 */
	public PDFRuntimeException(PDFException ex)
	{
		super(ex);
	}
	
	/**
	 * Creates a PDFRuntimeException by wrapping a Exception and a message
	 */
	public PDFRuntimeException(String message, Throwable ex)
	{
		super(message, ex);
	}
}
