/* ****************************************************************************
*
*	File: ObjectOperations.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.permissionprovider;

/**
 * This class provides access to all permission objects available in Acrobat 7.0 Professional. 
 * Not all permission objects have a meaningful purpose in <I>PDF Java Toolkit</I>. </P> 
 * 
 * @author speri
*/
public class  ObjectOperations 
{
	private String m_strID;

	private ObjectOperations(String strID)
	{
		m_strID = strID ;
	}
	
	@Override
	public String toString()
	{
		return m_strID;
	}


	/**
	 * Indicates whether the caller should be allowed to modify document that are not covered under one of the other,
	 * more granular permission objects like pages,links,annotations,bookmarks etc. Modifications included are 
	 * info/metadata, open actions, and page labels. Modifications to page contents 
	 * are controlled by {@link #PAGE_MODIFY}.
	 */
	//ID : 3
	public static final ObjectOperations  DOC_MODIFY = new ObjectOperations("DOC_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to copy to clipboard of text and images, including copying of text with
	 * format information.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 4
	public static final ObjectOperations  DOC_COPY = new ObjectOperations("DOC_COPY");
	
	/**
	 * Indicates whether the caller should be allowed to access accesibility features of the document.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 5
	public static final ObjectOperations  DOC_ACCESSIBLE = new ObjectOperations("DOC_ACCESSIBLE");
	
	/**
	 * Indicates whether the caller should be allowed to select any area in the document, 
	 * (for example, by the highlight tool).
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 6
	public static final ObjectOperations  DOC_SELECT = new ObjectOperations("DOC_SELECT");
	
	/**
	 * Indicates whether the caller should be allowed to open the document.
	 * <P><B>Affected Methods</B>  <BR>
	 * Not applicable.
	 */
	//ID : 7
	public static final ObjectOperations  DOC_OPEN = new ObjectOperations("DOC_OPEN");
	
	/**
	 * Indicates whether security settings for the document that are set by a security handler are allowed to be changed.
	 */
	//ID : 8
	public static final ObjectOperations  DOC_SECURE = new ObjectOperations("DOC_SECURE");
	 
	/**
	 * Indicates whether the caller should be allowed unrestricted printing.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 9
	public static final ObjectOperations  DOC_PRINT_HIGH = new ObjectOperations("DOC_PRINT_HIGH");
	
	/**
	 * Indicates whether the caller should be allowed print-as-image printing, at 150 dpi.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable. 
	 */
	//ID : 10
	public static final ObjectOperations  DOC_PRINT_LOW = new ObjectOperations("DOC_PRINT_LOW");
	
	/**
	 * Indicates whether the caller should be allowed to use "Summarize" feature on the document. 
	 * Summarizing is a User Interface display.
	 */
	//ID : 14
	public static final ObjectOperations  DOC_SUMMARIZE = new ObjectOperations("DOC_SUMMARIZE");
	
	/**
	 *  Indicates whether the caller should be allowed to insert other objects into the document.
	 */
	//ID : 15
	public static final ObjectOperations  DOC_INSERT = new ObjectOperations("DOC_INSERT");
	
	/**
	 * Indicates whether the caller should be allowed to reorder the highlighted content.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 17
	public static final ObjectOperations  DOC_REORDER = new ObjectOperations("DOC_REORDER");
	
	/**
	 * Indicates whether the caller should be allowed to do document full save.
	 * Full save allows users to save the document along with modified form and/or annotation data.
	 */
	//ID : 18
	public static final ObjectOperations  DOC_FULLSAVE = new ObjectOperations("DOC_FULLSAVE");
	
	/**
	 * Indicates whether the caller should be allowed to import from non-PDF sources
	 * (for example, dragging JPEG files into a document).
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable. 
	 */
	//ID : 19
	public static final ObjectOperations  DOC_IMPORT = new ObjectOperations("DOC_IMPORT");
	
	/**
	 * Indicates whether the caller should be allowed to extract to non-PDF files. This 
	 * includes allowing <b>Save As...</b> to file types
	 * other then PDF (for example, JPEG, RTF), export of images from the PDF file, and text
	 * extraction to enable search/find. Also, this applies to Document Compare because it
	 * makes a copy of the original document.
	 */
	//ID : 20
	public static final ObjectOperations  DOC_EXPORT = new ObjectOperations("DOC_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to spawn templates in the document. 
	 */
	//ID : 22
	public static final ObjectOperations  DOC_SPAWNTEMPLATE = new ObjectOperations("DOC_SPANTEMPLATE");
	
	/**
	 * Indicates whether the caller should be allowed to create pages. 
	 * This does not allow insertion of pages.
	 */
	//ID : 101
	public static final ObjectOperations  PAGE_CREATE = new ObjectOperations("PAGE_CREATE");

	/**
	 * Indicates whether the caller should be allowed to delete pages.
	 * <P><B>Affected Methods</B>  <BR>
	 * Not applicable.
	 */
	//ID : 102
	public static final ObjectOperations  PAGE_DELETE= new ObjectOperations("PAGE_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify pages. This allows page contents to be modified.
	 */
	//ID : 103
	public static final ObjectOperations  PAGE_MODIFY = new ObjectOperations("PAGE_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to duplicate pages.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 104
	public static final ObjectOperations  PAGE_COPY = new ObjectOperations("PAGE_COPY");
	
	/**
	 * Indicates whether the caller should be allowed to rotate pages.
	 */
	//ID : 112
	public static final ObjectOperations  PAGE_ROTATE = new ObjectOperations("PAGE_ROTATE");
	
	/**
	 * Indicates whether the caller should be allowed to crop pages.
	 */
	//ID : 113
	public static final ObjectOperations  PAGE_CROP = new ObjectOperations("PAGE_CROP");
	
	/**
	 * Indicates whether the caller should be allowed to insert pages into this document.
	 */
	//ID : 115
	public static final ObjectOperations  PAGE_INSERT = new ObjectOperations("PAGE_INSERT");
	
	/**
	 * Indicates whether the caller should be allowed to replace pages.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.  
	 */
	//ID : 116
	public static final ObjectOperations  PAGE_REPLACE = new ObjectOperations("PAGE_REPLACE");
	
	/**
	 * Indicates whether the caller should be allowed to reorder pages.
	 * <P><B>Affected Methods</B>  <BR>
	 * Not applicable.  
	 */
	//ID : 117
	public static final ObjectOperations  PAGE_REORDER = new ObjectOperations("PAGE_REORDER");
	
	/**
	 * Indicates whether the caller should be allowed to export pages.
	 */
	//ID : 120
	public static final ObjectOperations  PAGE_EXPORT = new ObjectOperations("PAGE_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to create links.
	 */
	//ID : 201
	public static final ObjectOperations  LINK_CREATE = new ObjectOperations("LINK_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete links.
	 */
	//ID : 202
	public static final ObjectOperations  LINK_DELETE= new ObjectOperations("LINK_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify links.
	 */
	//ID : 203
	public static final ObjectOperations  LINK_MODIFY = new ObjectOperations("LINK_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to import links.
	 */
	//ID : 219
	public static final ObjectOperations  LINK_IMPORT = new ObjectOperations("LINK_IMPORT");
	
	/**
	 * Indicates whether the caller should be allowed to export links.
	 */
	//ID : 220
	public static final ObjectOperations  LINK_EXPORT = new ObjectOperations("LINK_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to create bookmarks.
	 */
	//ID : 301
	public static final ObjectOperations  BOOKMARK_CREATE = new ObjectOperations("BOOKMARK_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete bookmarks.
	 */
	//ID : 302
	public static final ObjectOperations  BOOKMARK_DELETE= new ObjectOperations("BOOKMARK_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify bookmarks.
	 */
	//ID : 303
	public static final ObjectOperations  BOOKMARK_MODIFY = new ObjectOperations("BOOKMARK_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to export bookmarks.
	 */
	//ID : 320
	public static final ObjectOperations  BOOKMARK_EXPORT = new ObjectOperations("BOOKMARK_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to create embedded thumbnails for this document.
	 */
	//ID : 401
	public static final ObjectOperations  THUMBNAIL_CREATE = new ObjectOperations("THUMBNAIL_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete embedded thumbnails.
	 */
	//ID : 402
	public static final ObjectOperations  THUMBNAIL_DELETE= new ObjectOperations("THUMBNAIL_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to export thumbnail.
	 */
	//ID : 420
	public static final ObjectOperations  THUMBNAIL_EXPORT = new ObjectOperations("THUMBNAIL_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to create comments.
	 */
	//ID : 501
	public static final ObjectOperations  ANNOT_CREATE = new ObjectOperations("ANNOT_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete comments.
	 */
	//ID : 502
	public static final ObjectOperations  ANNOT_DELETE= new ObjectOperations("ANNOT_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify comments.
	 */
	//ID : 503
	public static final ObjectOperations  ANNOT_MODIFY = new ObjectOperations("ANNOT_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to copy comments to the clipboard (for example,
	 *  copy text from a comment).
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 504
	public static final ObjectOperations  ANNOT_COPY = new ObjectOperations("ANNOT_COPY");
	
	/**
	 * Indicates whether the caller should be allowed to summarize comments. 
	 * Summarizing is a User Interface display.
	 * <P><B>Affected Methods</B>  <BR>
	 * Not applicable.
	 */
	//ID : 514
	public static final ObjectOperations  ANNOT_SUMMARIZE = new ObjectOperations("ANNOT_SUMMARIZE");
	
	/**
	 * Indicates whether the caller should be allowed to import comments into the document.
	 */
	//ID : 519
	public static final ObjectOperations  ANNOT_IMPORT = new ObjectOperations("ANNOT_IMPORT");
	
	/**
	 * Indicates whether the caller should be allowed to export comments from this document.
	 */
	//ID : 520
	public static final ObjectOperations  ANNOT_EXPORT = new ObjectOperations("ANNOT_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to comment online.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable. 
	 */
	//ID : 523
	public static final ObjectOperations  ANNOT_ONLINE = new ObjectOperations("ANNOT_ONLINE");
	
	/**
	 * Indicates whether the caller should be allowed to view the comments summary in a document.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 524
	public static final ObjectOperations  ANNOT_SUMMARY_VIEW = new ObjectOperations("ANNOT_SUMMARY_VIEW");
	
	
	/**
	 * Indicates whether the caller should be allowed to create form field types, 
	 * excluding signature form fields.
	 */
	//ID : 601
	public static final ObjectOperations  FORM_CREATE = new ObjectOperations("FORM_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete all form field types, excluding signature form fields.
	 */
	//ID : 602
	public static final ObjectOperations  FORM_DELETE= new ObjectOperations("FORM_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify properties of all form field types, excluding signature
	 * form fields.
	 */
	//ID : 603
	public static final ObjectOperations  FORM_MODIFY = new ObjectOperations("FORM_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to fill-in form field types, excluding signature form fields. This allows
	 * form field values to be changed.
	 */
	//ID : 611
	public static final ObjectOperations  FORM_FILLIN = new ObjectOperations("FORM_FILLIN");
	
	/**
	 * Indicates whether the caller should be allowed to import form data into this document. Can include signature fields.
	 */
	//ID : 619
	public static final ObjectOperations  FORM_IMPORT = new ObjectOperations("FORM_IMPORT");
	
	/**
	 * Indicates whether the caller should be allowed to export form data out of this document to a file. 
	 */
	//ID : 620
	public static final ObjectOperations  FORM_EXPORT = new ObjectOperations("FORM_EXPORT");
	
	/**
	 * Indicates whether the caller should be allowed to submit form online.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 621
	public static final ObjectOperations  FORM_SUBMIT_STANDALONE = new ObjectOperations("FORM_SUBMIT_STANDALONE");
	
	/**
	 * Indicates whether the caller should be allowed to spawn a page template. 
	 */
	//ID : 622
	public static final ObjectOperations  FORM_SPAWN_TEMPLATE = new ObjectOperations("FORM_SPAWN_TEMPLATE");
	
	/**
	 * Indicates whether the caller should be allowed to perform form-specific online mechanisms 
	 * (for example, SOAP or Active Data Object).
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 623
	public static final ObjectOperations  FORM_ONLINE = new ObjectOperations("FORM_ONLINE");
	
	/**
	 * Indicates whether the caller should be allowed to encode the annotation appearance for form fields as a plaintext
	 * barcode, that can be read by any third party barcode decoding software. If not
	 * enabled, the barcode will be encoded in an Adobe proprietary fashion.
	 * This applies only for text form fields where XFA marks the field as a barcode. For
	 * classic forms fields the field is considered a barcode field if the DataPrep entry
	 * can be found in the field dictionary.
	 * <P><B>Affected Methods</B> <BR>
	 * Not applicable.
	 */
	//ID : 625
	public static final ObjectOperations  FORM_BARCODE_PLAINTEXT = new ObjectOperations("FORM_BARCODE_PLAINTEXT");
	
	/**
	 * Indicates whether the caller should be allowed to create new signature fields.
	 */
	//ID : 701
	public static final ObjectOperations  SIGNATURE_CREATE = new ObjectOperations("SIGNATURE_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete signature fields.
	 */
	//ID : 702
	public static final ObjectOperations  SIGNATURE_DELETE= new ObjectOperations("SIGNATURE_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify signature field properties of existing signature fields.
	 */
	//ID : 703
	public static final ObjectOperations  SIGNATURE_MODIFY = new ObjectOperations("SIGNATURE_MODIFY");
	
	/**
	 *  Indicates whether the caller should be allowed to signing and clearing of existing signature fields.
	 */
	//ID : 711
	public static final ObjectOperations  SIGNATURE_FILLIN = new ObjectOperations("SIGNATURE_FILLIN");
	
	/**
	 * Indicates whether the caller should be allowed to create Named Embedded Files.
	 */
	//ID : 801
	public static final ObjectOperations  EF_CREATE = new ObjectOperations("EF_CREATE");
	
	/**
	 * Indicates whether the caller should be allowed to delete Named Embedded Files.
	 */
	//ID : 802
	public static final ObjectOperations  EF_DELETE= new ObjectOperations("EF_DELETE");
	
	/**
	 * Indicates whether the caller should be allowed to modify a Named Embedded File. An example is to open an
	 * embedded file that is a PDF file, make changes, then save the modified PDF
	 * back into the host file.
	 */
	//ID : 803
	public static final ObjectOperations  EF_MODIFY = new ObjectOperations("EF_MODIFY");
	
	/**
	 * Indicates whether the caller should be allowed to import Named Embedded Files. Creation or
	 * modification of Named Embedded Files is not enabled by this operation and
	 * must be enabled separately as required.
	 */
	//ID : 819
	public static final ObjectOperations  EF_IMPORT = new ObjectOperations("EF_IMPORT");
	
	/**
	 *  Indicates whether the caller should be allowed to export named embeded files out of this PDF file. The primary
	 * motivation of this permission is to control javascript.
	 */
	//ID : 820
	public static final ObjectOperations  EF_EXPORT = new ObjectOperations("EF_EXPORT");

}
