/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;


/**
 * A base class for all lists that are used in the XFA scripting object model.
 * That includes primarily node lists, but also lists of deltas.
 * This class combined with XFAList correspond to the C++ XFAListImpl class.
 */
public abstract class ListBase extends Obj {

	boolean mbReadOnly;

	/**
	 * @exclude from published api.
	 */
	protected ListBase() {
		mbReadOnly = false;
	}

	/**
	 * @exclude from published api.
	 */
	protected ListBase(boolean bReadOnly) {
		mbReadOnly = bReadOnly;
	}

	/**
	 * Appends an object to the end of this list.
	 * 
	 * @param oObj the node to be appended.
	 */
	abstract public void append(Obj oObj);

	/**
	 * @see Obj#getClassAtom()
	 *
	 * @exclude from published api.
	 */
	public String getClassAtom() {
		return STRS.LIST;
	}

	/**
	 * @see Obj#getClassName()
	 *
	 * @exclude from published api.
	 */
	public String getClassName() {
		return STRS.LIST;
	}

	/**
	 * @exclude from published api.
	 */
	public ScriptTable getScriptTable() {
		return ListBaseScript.getScriptTable();
	}
	
	/**
	 * Inserts an object before a specific node in this list.
	 * 
	 * @param newObj the object to be inserted.
	 * @param refObj the object to insert before.
	 */
	abstract public void insert(Obj newObj, Obj refObj);

	/**
	 * @exclude from published api.
	 */
	public boolean isReadOnly() {
		return mbReadOnly;
	}

	/**
	 * @exclude from published api.
	 */
	public void isReadOnly(boolean bReadOnly) {
		mbReadOnly = bReadOnly;
	}

	/**
	 * Gets this list's n'th object.
	 * 
	 * @param n the 0-based index of the node within this list.
	 * @return the n'th node.
	 */
	abstract public Obj item(int n);

	/**
	 * Returns the number of objects in this list.
	 * 
	 * @return the length of this list.
	 */
	abstract public int length();

	/**
	 * Removes an object from this list.
	 * 
	 * @param obj the object to be removed.
	 */
	abstract public void remove(Obj obj);
	
	/* @exclude from published api. */
	abstract boolean appendPermsCheck();
	
	/* @exclude from published api. */
	abstract boolean removePermsCheck(Obj obj);
	
	/* @exclude from published api. */
	abstract boolean insertPermsCheck();
}