/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


import com.adobe.xfa.ut.trace.Trace;


/**
 * This class contains all the script functionality associated with the
 * LogPseudoModel class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class LogPseudoModelScript extends PseudoModelScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		PseudoModelScript.moScriptTable,
		"logPseudoModel",
		null,
		new ScriptFuncObj[] {
			new ScriptFuncObj(LogPseudoModelScript.class, "message", "message", Arg.EMPTY,
				new int[] { Arg.INTEGER, Arg.STRING, Arg.STRING/*, XFA_IS_MESSAGE_PARAM1, XFA_IS_MESSAGE_PARAM2, XFA_IS_MESSAGE_PARAM3*/ }, 2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_MESSAGE_DESC, 0, null*/, 0),
			new ScriptFuncObj(LogPseudoModelScript.class, "traceActivate", "traceActivate", Arg.EMPTY,
				new int[] { Arg.STRING/*, XFA_IS_TRACEACTIVATE_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TRACEACTIVATE_DESC, 0, null*/, 0),
			new ScriptFuncObj(LogPseudoModelScript.class, "traceDeactivate", "traceDeactivate", Arg.EMPTY,
				new int[] { Arg.STRING/*, XFA_IS_TRACEDEACTIVATE_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TRACEDEACTIVATE_DESC, 0, null*/, 0),
			new ScriptFuncObj(LogPseudoModelScript.class, "traceEnabled", "traceEnabled", Arg.BOOL,
				new int[] { Arg.STRING, Arg.INTEGER/*, XFA_IS_TRACEENABLED_PARAM1, XFA_IS_TRACEENABLED_PARAM2*/ }, 2, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TRACEENABLED_DESC, XFA_IS_TRACEENABLED_RET, null*/, 0),
			new ScriptFuncObj(LogPseudoModelScript.class, "trace", "trace", Arg.EMPTY,
				new int[] { Arg.STRING, Arg.INTEGER, Arg.INTEGER, Arg.STRING/*, XFA_IS_TRACE_PARAM1, XFA_IS_TRACE_PARAM2, XFA_IS_TRACE_PARAM3, XFA_IS_TRACE_PARAM4*/ }, 4, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TRACE_DESC, 0, null*/, 0)
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void message(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		if (pArgs.length == 2)
			((LogPseudoModel) pObj).message(pArgs[0].getInteger().intValue(), pArgs[1].getString(), "i");
		else if (pArgs.length == 3)
			((LogPseudoModel) pObj).message(pArgs[0].getInteger().intValue(), pArgs[1].getString(), pArgs[2].getString());
	}

	public static void traceActivate(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((LogPseudoModel) pObj).traceActivate(pArgs[0].getString());
	}

	public static void traceDeactivate(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((LogPseudoModel) pObj).traceDeactivate(pArgs[0].getString());
	}

	public static void traceEnabled(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setBool(Boolean.valueOf(Trace.isEnabled(pArgs[0].getString(), pArgs[1].getInteger().intValue())));
	}

	public static void trace(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((LogPseudoModel) pObj).trace(pArgs[0].getString(), pArgs[1].getInteger().intValue(), pArgs[2].getInteger().intValue(), pArgs[3].getString());
	}
}
