/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;

import com.adobe.xfa.Obj;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.Node;
import com.adobe.xfa.template.binding.BindingNode;

import java.util.ArrayList;
import java.util.List;

/**
 * @exclude from public api.
 */
public class FormItemsDataListener extends Obj {

	private Node				mFormNode;  // form field with list ui
	private final BindingNode	mBindItemsNode;
	private final List<Node>	mDataNodes = new ArrayList<Node>();
	private final List<Boolean>	mDataNodeTypes = new ArrayList<Boolean>();
	
	// public 
	
	public FormItemsDataListener(Node formNode, Node bindingNode) {
		assert formNode instanceof FormField;
		assert bindingNode instanceof BindingNode;
		
		mFormNode = formNode;
		mBindItemsNode = (BindingNode)bindingNode;
	}


	//	~XFAFormItemsDataListener() {
	void dispose() {
		// JavaPort: The C++ version calls clearDataPeers(false), which is wrong-ish, and maps to the following.
		clearDataPeers(null);
	}

	/**
	 * @see Obj#getClassAtom()
	 */
	public String getClassAtom() {
		return "formDataListener";	// TODO: Should this be in STRS?
	}
	
	/**
	 * @see Obj#getClassName()
	 */
	public String getClassName() {
		return "formDataListener";
	}

	void addDataNode(Node dataNode, boolean bIsItemValue) {
		for (int i = 0; i < mDataNodes.size(); i++) {
			if (mDataNodes.get(i) == dataNode) {
				mDataNodeTypes.set(i, Boolean.valueOf(bIsItemValue));
				return;
			}
		}

		dataNode.addPeer(this);
		mDataNodes.add(dataNode);
		mDataNodeTypes.add(Boolean.valueOf(bIsItemValue));
	}

	Node getFormNode() {
		return mFormNode;
	}

	// overridden from Peer
	public void updateFromPeer(Object peerNode, 
						int eventType, 
						String arg1, 
						Object arg2) {
		
		for (int index = 0; index < mDataNodes.size(); index++) {
			if (mDataNodes.get(index) == peerNode) {
				boolean bIsItemType = mDataNodeTypes.get(index).booleanValue();
				switch (eventType) {
				case Peer.VALUE_CHANGED:
					if (bIsItemType) {
						// reset the data node peers
						clearDataPeers(mDataNodes.get(index));
						// update the items
						((FormField)mFormNode).updateItemsFromData(mBindItemsNode, false);
					}
					break;

				case Peer.CHILD_ADDED:
				case Peer.CHILD_REMOVED:
					if (!bIsItemType) {
						// reset the data node peers
						clearDataPeers(mDataNodes.get(index));
						// update the items
						((FormField)mFormNode).updateItemsFromData(mBindItemsNode, false);
					}
					break;
				}
				break;
			}
		}
	}	
	
    private void clearDataPeers(Node keepDataPeer) {
    	for (int i = mDataNodes.size(); i > 0; i--) {
    		if (keepDataPeer == null || mDataNodes.get(i - 1) != keepDataPeer) {
    			// removing the peer automatically removes the entry from
    			// moDataNodes and moDataNodeTypes via peerRemoved()
    			mDataNodes.get(i - 1).removePeer(this);
    		}
    	}
    }
    
    public void peerRemoved(Peer pPeer) {
    	for (int nIndex = 0; nIndex < mDataNodes.size(); nIndex++) {
    		if (mDataNodes.get(nIndex) == pPeer) {
    			// TODO update the items list
    			mDataNodes.remove(nIndex);
    			mDataNodeTypes.remove(nIndex);
    			break;
    		}
    	}
    	
    	if (pPeer == mFormNode) {
    		mFormNode = null;
    	}
    }
}
