/*************************************************************************
 *
 *	File: BarcodeEncoder.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.common;

import java.awt.image.BufferedImage;

/**
 * Represents the interface that should be implemented by all Barcode Encoders
 * 
 * @author shakumar
 */
public interface BarcodeEncoder {
	/**
	 * Encodes the message in a barcode and returns it as an image
	 * 
	 * @param message
	 *            message to be encoded in barcode
	 * @param pmpParams
	 *            barcode params
	 * @return barcode image
	 * @throws BarcodeEncoderException
	 */
	BufferedImage encode(char[] message, BarcodeGenerationParams pmpParams)
			throws BarcodeEncoderException;
}
