/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2008 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.formatting;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.Schema;
import com.adobe.xfa.XFA;

/**
 * This class implements the functionality represented by the XFA <button>
 * element.
 *
 * @exclude from published api
 */

public final class Button extends ProtoableNode {
	public Button(Element parent, Node prevSibling) {
		super(parent, prevSibling, null, XFA.BUTTON, XFA.BUTTON, null,
				XFA.BUTTONTAG, XFA.BUTTON);
	}

	public Attribute defaultAttribute(int eTag) {
		// If we're an unspecified property, the default value of presence is
		// hidden.
		if (eTag == XFA.HIGHLIGHTTAG) {
			int nVersion = getModel().getCurrentVersion();
			if (nVersion == Schema.XFAVERSION_25) {
				return EnumValue.getEnum(XFA.HIGHLIGHTTAG, EnumAttr.getEnum(EnumAttr.HIGHLIGHT_PUSH));
			}
		}

		// Not special case, so let the base class handle it
		return super.defaultAttribute(eTag);
	}
}
