//----------------------------------------------------------------------
//
// File: atsrccop.cpp
//
// Description
//		Implementation file for class AttrCopy.
//
// Change history
//	Project 	Release Date	Who 	Review	What
//	HawaiiRd	5.0 	950329	RD				Created.
//
//----------------------------------------------------------------------
package com.adobe.xfa.text;


import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontService;


/**
 * @exclude from published api.
 */
class AttrCopy {
	final static int COPY_ALL = 0;
	final static int OVERRIDE_ONLY = 1;
	final static int ADD_DISABLED = 2;

	private final TextAttr mpoSource;
	private final int meCopy;
	private TextAttr mpoAttr;
	private long mnMask;
	private TextAttr mpoDiffs;
	private long mnDiffMask;

	AttrCopy (TextAttr poSource, int eCopy) {
		mpoSource = poSource;
		meCopy = eCopy;
	}

	void copy (TextAttr poDest) {
		copy (poDest, null);
	}

	void copy (TextAttr poDest, TextAttr poDiffs) {
		mpoAttr = poDest;
		mnMask = 0;
		mpoDiffs = poDiffs;
		mnDiffMask = 0;

// First, establish who controls which attributes are to be copied and
// which "enable" value causes a copy.
		TextAttr poEnableSource;
		boolean bEnable;
		if (meCopy == ADD_DISABLED) {
			poEnableSource = poDest;	// Copy if destination ...
			bEnable = false;			// ... attributes are disabled
		} else {
			poEnableSource = mpoSource;	// Copy if source ...
			bEnable = true;				// ... attributes are enabled
		}

// Copy the font service if it exists
		FontService poNewFontService = mpoSource.fontService();
		boolean bPendingFontServiceChange = false;
		if ((poNewFontService != null) && (poNewFontService != poDest.fontService())) {
			bPendingFontServiceChange = true;
		}

// If the source has a font, use it.
		if (mpoSource.fontEnable() && (poEnableSource.fontEnable() == bEnable) && (poEnableSource.anyFontEnable() == bEnable)) {
			if (bPendingFontServiceChange) {
				poDest.fontService (poNewFontService, true);
			}
			fontInstance (mpoSource.fontInstance(), "");

// Otherwise, construct what we can of the font, using the individual
// settings enabled in the source.
		} else {
			TextAttr.FontDesc oFontDesc = new TextAttr.FontDesc();

			if (mpoSource.typefaceEnable() && (poEnableSource.typefaceEnable() == bEnable)) {
				oFontDesc.setTypeface (mpoSource.typeface());
			}
			if (mpoSource.encodingEnable() && (poEnableSource.encodingEnable() == bEnable)) {
//				oFontDesc.setEncoding (mpoSource.encoding());
			}
			if (mpoSource.sizeEnable() && (poEnableSource.sizeEnable() == bEnable)) {
				oFontDesc.setSize (mpoSource.size());
			}
			if (mpoSource.weightEnable() && (poEnableSource.weightEnable() == bEnable)) {
				oFontDesc.setWeight (mpoSource.weight());
			}
			if (mpoSource.italicEnable() && (poEnableSource.italicEnable() == bEnable)) {
				oFontDesc.setItalic (mpoSource.italic());
			}
			if (mpoSource.horizontalScaleEnable() && (poEnableSource.horizontalScaleEnable() == bEnable)) {
				oFontDesc.setHorizontalScale (mpoSource.horizontalScale());
			}
			if (mpoSource.verticalScaleEnable() && (poEnableSource.verticalScaleEnable() == bEnable)) {
				oFontDesc.setVerticalScale (mpoSource.verticalScale());
			}

			if (! oFontDesc.isEmpty()) {
//				if (bPendingFontServiceChange) {
//					poDest.FontService (poNewFontService, true);
//				}
				font (oFontDesc);
			}
		}

//		if (((eCopy == COPY_ALL) || (eCopy == OVERRIDE_ONLY))
//		 && (mpoSource.GfxTextAttrEnable())
//		 && (mpoSource.AttrPool() == poDest.AttrPool())
//		 && (mpoSource.AttrPool() != null)
//		 && (poDest.AttrPool().AddPointer (mpoSource.GfxTextAttr()))) {
//// If we have some form of source controlled copy, the source is
//// complete, the attribute pools match and this attribute exists in the
//// pool, add by pointer for efficiency.
//			GfxAttr (mpoSource.GfxTextAttr());
//		} else {
// Otherwise, do individual graphic attributes, dealing with only those
// that we need to copy.
			TextGfxAttr oTextGfxAttr = new TextGfxAttr();

			if (mpoSource.underlineEnable() && (poEnableSource.underlineEnable() == bEnable)) {
				oTextGfxAttr.underline (mpoSource.underline());
			}
			if (mpoSource.overlineEnable() && (poEnableSource.overlineEnable() == bEnable)) {
				oTextGfxAttr.overline (mpoSource.overline());
			}
			if (mpoSource.strikeoutEnable() && (poEnableSource.strikeoutEnable() == bEnable)) {
				oTextGfxAttr.strikeout (mpoSource.strikeout());
			}

			if (mpoSource.textContextEnable() && (poEnableSource.textContextEnable() == bEnable)) {
				oTextGfxAttr.textContext (mpoSource.textContext());
			}
			if (mpoSource.graphicContextEnable() && (poEnableSource.graphicContextEnable() == bEnable)) {
				oTextGfxAttr.graphicContext (mpoSource.graphicContext());
			}

			if (mpoSource.colourEnable() && (poEnableSource.colourEnable() == bEnable)) {
				oTextGfxAttr.colour (mpoSource.colour());
			}
			if (mpoSource.colourBgEnable() && (poEnableSource.colourBgEnable() == bEnable)) {
				oTextGfxAttr.colourBg (mpoSource.colourBg());
			}

			if (mpoSource.styleEnable() && (poEnableSource.styleEnable() == bEnable)) {
				oTextGfxAttr.style (mpoSource.style());
			}
			if (mpoSource.shadeEnable() && (poEnableSource.shadeEnable() == bEnable)) {
				oTextGfxAttr.shade (mpoSource.shade());
			}
			if (mpoSource.shadeScaleEnable() && (poEnableSource.shadeScaleEnable() == bEnable)) {
				oTextGfxAttr.shadeScale (mpoSource.shadeScale());
			}

			gfxAttr (oTextGfxAttr);
//		}

// Now, do all the miscellaneous attributes.
		if (mpoSource.transparentEnable() && (poEnableSource.transparentEnable() == bEnable)) {
			transparent (mpoSource.transparent());
		}

		if (mpoSource.spacingEnable() && (poEnableSource.spacingEnable() == bEnable)) {
			spacing (mpoSource.spacing());
		}

		if (mpoSource.marginLEnable() && (poEnableSource.marginLEnable() == bEnable)) {
			marginL (mpoSource.marginL());
		}
		if (mpoSource.marginREnable() && (poEnableSource.marginREnable() == bEnable)) {
			marginR (mpoSource.marginR());
		}

		if (mpoSource.justifyVEnable() && (poEnableSource.justifyVEnable() == bEnable)) {
			justifyV (mpoSource.justifyV());
		}
		if (mpoSource.justifyHEnable() && (poEnableSource.justifyHEnable() == bEnable)) {
			justifyH (mpoSource.justifyH());
		}

		if (mpoSource.radixOffsetEnable() && (poEnableSource.radixOffsetEnable() == bEnable)) {
			radixOffset (mpoSource.radixOffset());
		}

		if (mpoSource.radixPosEnable() && (poEnableSource.radixPosEnable() == bEnable)) {
			radixPos (mpoSource.radixPos());
		}

		if (mpoSource.tabsEnable() && (poEnableSource.tabsEnable() == bEnable)) {
			tabs (mpoSource.tabs());
		}

		if (mpoSource.specialEnable() && (poEnableSource.specialEnable() == bEnable)) {
			special (mpoSource.special());
		}

		if (mpoSource.spaceBeforeEnable() && (poEnableSource.spaceBeforeEnable() == bEnable)) {
			spaceBefore (mpoSource.spaceBefore());
		}

		if (mpoSource.spaceAfterEnable() && (poEnableSource.spaceAfterEnable() == bEnable)) {
			spaceAfter (mpoSource.spaceAfter());
		}

		if (mpoSource.invisibleEnable() && (poEnableSource.invisibleEnable() == bEnable)) {
			invisible (mpoSource.invisible());
		}
		if (mpoSource.invisCharEnable() && (poEnableSource.invisCharEnable() == bEnable)) {
			InvisChar (mpoSource.invisChar());
		}

		if (mpoSource.baselineShiftEnable() && (poEnableSource.baselineShiftEnable() == bEnable)) {
			baselineShift (mpoSource.baselineShift());
		}

		if (mpoSource.localeEnable() && (poEnableSource.localeEnable() == bEnable)) {
			locale (mpoSource.locale());
		}

		if (mpoSource.digitsEnable() && (poEnableSource.digitsEnable() == bEnable)) {
			digits (mpoSource.digits());
		}

		if (mpoSource.directionEnable() && (poEnableSource.directionEnable() == bEnable)) {
			direction (mpoSource.direction());
		}

		if (mpoSource.paraDirectionEnable() && (poEnableSource.paraDirectionEnable() == bEnable)) {
			paraDirection (mpoSource.paraDirection());
		}

		if (mpoSource.layoutOrientationEnable() && (poEnableSource.layoutOrientationEnable() == bEnable)) {
			layoutOrientation (mpoSource.layoutOrientation());
		}

		if (mpoSource.ligatureEnable() && (poEnableSource.ligatureEnable() == bEnable)) {
			ligature (mpoSource.ligature());
		}

		if (mpoSource.charSpacingEnable() && (poEnableSource.charSpacingEnable() == bEnable)) {
			charSpacing (mpoSource.charSpacing());
		}
		if (mpoSource.wordSpacingEnable() && (poEnableSource.wordSpacingEnable() == bEnable)) {
			wordSpacing (mpoSource.wordSpacing());
		}

		if (mpoSource.kerningEnable() && (poEnableSource.kerningEnable() == bEnable)) {
			kerning (mpoSource.kerning());
		}

		if (mpoSource.hyphLevelEnable() && (poEnableSource.hyphLevelEnable() == bEnable)) {
			hyphLevel (mpoSource.hyphLevel());
		}
		if (mpoSource.hyphMinWordEnable() && (poEnableSource.hyphMinWordEnable() == bEnable)) {
			hyphMinWord (mpoSource.hyphMinWord());
		}
		if (mpoSource.hyphMinPrefixEnable() && (poEnableSource.hyphMinPrefixEnable() == bEnable)) {
			hyphMinPrefix (mpoSource.hyphMinPrefix());
		}
		if (mpoSource.hyphMinSuffixEnable() && (poEnableSource.hyphMinSuffixEnable() == bEnable)) {
			hyphMinSuffix (mpoSource.hyphMinSuffix());
		}
		if (mpoSource.hyphMaxLinesEnable() && (poEnableSource.hyphMaxLinesEnable() == bEnable)) {
			hyphMaxLines (mpoSource.hyphMaxLines());
		}
		if (mpoSource.hyphSuppressNamesEnable() && (poEnableSource.hyphSuppressNamesEnable() == bEnable)) {
			hyphSuppressNames (mpoSource.hyphSuppressNames());
		}
		if (mpoSource.hyphSuppressAcronymsEnable() && (poEnableSource.hyphSuppressAcronymsEnable() == bEnable)) {
			hyphSuppressAcronyms (mpoSource.hyphSuppressAcronyms());
		}

		if (mpoSource.leaderPatternEnable() && (poEnableSource.leaderPatternEnable() == bEnable)) {
			leaderPattern (mpoSource.leaderPattern());
		}
		if (mpoSource.leaderPatternWidthEnable() && (poEnableSource.leaderPatternWidthEnable() == bEnable)) {
			leaderPatternWidth (mpoSource.leaderPatternWidth());
		}
		if (mpoSource.leaderAlignEnable() && (poEnableSource.leaderAlignEnable() == bEnable)) {
			leaderAlign (mpoSource.leaderAlign());
		}
		if (mpoSource.leaderContentEnable() && (poEnableSource.leaderContentEnable() == bEnable)) {
			leaderContent (mpoSource.leaderContent());
		}
		if (mpoSource.ruleStyleEnable() && (poEnableSource.ruleStyleEnable() == bEnable)) {
			ruleStyle (mpoSource.ruleStyle());
		}
		if (mpoSource.ruleThicknessEnable() && (poEnableSource.ruleThicknessEnable() == bEnable)) {
			ruleThickness (mpoSource.ruleThickness());
		}

// If this is not an override (i.e., full copy), disable all attributes
// not enabled in the source.
		if (meCopy == COPY_ALL) {
			disableNotPresent();
		}
		disableNotPresentDiffs();
	}

	protected void font (TextAttr.FontDesc oNewFontDesc) {
		TextAttr.FontDesc oFontDesc = new TextAttr.FontDesc();
		long nMask = 0;

		if (oNewFontDesc.hasTypeface() != TextAttr.FontDesc.VALUE_ABSENT) {
			if (!oNewFontDesc.getTypeface().equals(mpoAttr.typeface())) {
				oFontDesc.setTypeface (oNewFontDesc.getTypeface());
				nMask |= Pkg.AM_TYPEFACE;
			}
			mnMask |= Pkg.AM_TYPEFACE;
		}

		if (oNewFontDesc.hasSize() != TextAttr.FontDesc.VALUE_ABSENT) {
			if (!oNewFontDesc.getSize().equals(mpoAttr.size())) {
				oFontDesc.setSize (oNewFontDesc.getSize());
				nMask |= Pkg.AM_SIZE;
			}
			mnMask |= Pkg.AM_SIZE;
		}

		if (oNewFontDesc.hasWeight() != TextAttr.FontDesc.VALUE_ABSENT) {
			if (oNewFontDesc.getWeight() != mpoAttr.weight()) {
				oFontDesc.setWeight (oNewFontDesc.getWeight());
				nMask |= Pkg.AM_WEIGHT;
			}
			mnMask |= Pkg.AM_WEIGHT;
		}

		if (oNewFontDesc.hasItalic() != TextAttr.FontDesc.VALUE_ABSENT) {
			if ((! mpoAttr.italicEnable()) || (oNewFontDesc.getItalic() != mpoAttr.italic())) {
				oFontDesc.setItalic (oNewFontDesc.getItalic());
				nMask |= Pkg.AM_ITALIC;
			}
			mnMask |= Pkg.AM_ITALIC;
		}

		if (oNewFontDesc.hasHorizontalScale() != TextAttr.FontDesc.VALUE_ABSENT) {
			if ((! mpoAttr.horizontalScaleEnable()) || (oNewFontDesc.getHorizontalScale() != mpoAttr.horizontalScale())) {
				oFontDesc.setHorizontalScale (oNewFontDesc.getHorizontalScale());
				nMask |= Pkg.AM_HORIZONTAL_SCALE;
			}
			mnMask |= Pkg.AM_HORIZONTAL_SCALE;
		}

		if (oNewFontDesc.hasVerticalScale() != TextAttr.FontDesc.VALUE_ABSENT) {
			if ((! mpoAttr.verticalScaleEnable()) || (oNewFontDesc.getVerticalScale() != mpoAttr.verticalScale())) {
				oFontDesc.setVerticalScale (oNewFontDesc.getVerticalScale());
				nMask |= Pkg.AM_VERTICAL_SCALE;
			}
			mnMask |= Pkg.AM_VERTICAL_SCALE;
		}

		if (nMask != 0) {
			mpoAttr.updateFont (oFontDesc);

			if (mpoDiffs != null) {
				mpoDiffs.updateFont (oFontDesc);
				mnDiffMask |= nMask;
				if ((mnDiffMask & Pkg.AM_FONT_PARMS) == Pkg.AM_FONT_PARMS) {
					mnDiffMask |= Pkg.AM_FONT;
				}
			}
		}

		if ((mnMask & Pkg.AM_FONT_PARMS) == Pkg.AM_FONT_PARMS) {
			mnMask |= Pkg.AM_FONT;
		}
	}

	private void fontInstance (FontInstance oNewFont, String sOriginalTypeface) {
		if (oNewFont != mpoAttr.fontInstance()) {
			mpoAttr.fontInstance (oNewFont, sOriginalTypeface);

			if (mpoDiffs != null) {
				mpoDiffs.fontInstance (oNewFont, sOriginalTypeface);
				mnDiffMask |= Pkg.AM_ALL_FONT;
			}
		}

		mnMask |= Pkg.AM_ALL_FONT;
	}

	protected void gfxAttr (TextGfxAttr oNewAttr) {
		long nMask = 0;

		if (oNewAttr.underlineEnable()) {
			if (oNewAttr.underline() != mpoAttr.underline()) {
				nMask |= Pkg.AM_UNDERLINE;
			} else {
				oNewAttr.underlineEnable (false);
			}
			mnMask |= Pkg.AM_UNDERLINE;
		}

		if (oNewAttr.overlineEnable()) {
			if (oNewAttr.overline() != mpoAttr.overline()) {
				nMask |= Pkg.AM_OVERLINE;
			} else {
				oNewAttr.overlineEnable (false);
			}
			mnMask |= Pkg.AM_OVERLINE;
		}

		if (oNewAttr.strikeoutEnable()) {
			if (oNewAttr.strikeout() != mpoAttr.strikeout()) {
				nMask |= Pkg.AM_LINE_THROUGH;
			} else {
				oNewAttr.strikeoutEnable (false);
			}
			mnMask |= Pkg.AM_LINE_THROUGH;
		}

		if (oNewAttr.textContextEnable()) {
			if ((! mpoAttr.textContextEnable()) || (oNewAttr.textContext() != mpoAttr.textContext())) {
				nMask |= Pkg.AM_TEXT_CONTEXT;
			} else {
				oNewAttr.textContextEnable (false);
			}
			mnMask |= Pkg.AM_TEXT_CONTEXT;
		}

		if (oNewAttr.graphicContextEnable()) {
			if ((! mpoAttr.graphicContextEnable()) || (oNewAttr.graphicContext() != mpoAttr.graphicContext())) {
				nMask |= Pkg.AM_GRAPHIC_CONTEXT;
			} else {
				oNewAttr.graphicContextEnable (false);
			}
			mnMask |= Pkg.AM_GRAPHIC_CONTEXT;
		}

		if (oNewAttr.colourEnable()) {
			if ((! mpoAttr.colourEnable()) || (oNewAttr.colour() != mpoAttr.colour())) {
				nMask |= Pkg.AM_COLOUR;
			} else {
				oNewAttr.colourEnable (false);
			}
			mnMask |= Pkg.AM_COLOUR;
		}

		if (oNewAttr.colourBgEnable()) {
			if ((! mpoAttr.colourBgEnable()) || (oNewAttr.colourBg() != mpoAttr.colourBg())) {
				nMask |= Pkg.AM_COLOURBG;
			} else {
				oNewAttr.colourBgEnable (false);
			}
			mnMask |= Pkg.AM_COLOURBG;
		}

		if (oNewAttr.styleEnable()) {
			if (oNewAttr.style() != mpoAttr.style()) {
				nMask |= Pkg.AM_STYLE;
			} else {
				oNewAttr.styleEnable (false);
			}
			mnMask |= Pkg.AM_STYLE;
		}

		if (oNewAttr.shadeEnable()) {
			if ((! mpoAttr.shadeEnable()) || (oNewAttr.shade() != mpoAttr.shade())) {
				nMask |= Pkg.AM_SHADE;
			} else {
				oNewAttr.shadeEnable (false);
			}
			mnMask |= Pkg.AM_SHADE;
		}

		if (oNewAttr.shadeScaleEnable()) {
			if ((! mpoAttr.shadeScaleEnable()) || (oNewAttr.shadeScale() != mpoAttr.shadeScale())) {
				nMask |= Pkg.AM_SHADESCALE;
			} else {
				oNewAttr.shadeScaleEnable (false);
			}
			mnMask |= Pkg.AM_SHADESCALE;
		}

		if (nMask != 0) {
			mpoAttr.applyGfxTextAttrs (oNewAttr);
			if (mpoDiffs != null) {
				mpoDiffs.applyGfxTextAttrs (oNewAttr);
				mnDiffMask |= nMask;
			}
		}
	}

	private void transparent (boolean bNewTransparent) {
		if ((! mpoAttr.transparentEnable()) || (bNewTransparent != mpoAttr.transparent())) {
			mpoAttr.transparent (bNewTransparent);
			if (mpoDiffs != null) {
				mpoDiffs.transparent (bNewTransparent);
				mnDiffMask |= Pkg.AM_TRANSPARENT;
			}
		}

		mnMask |= Pkg.AM_TRANSPARENT;
	}

	private void spacing (TextMeasurement oNewSpacing) {
		if ((! mpoAttr.spacingEnable()) || (! oNewSpacing.equals (mpoAttr.spacing()))) {
			mpoAttr.spacing (oNewSpacing);
			if (mpoDiffs != null) {
				mpoDiffs.spacing (oNewSpacing);
				mnDiffMask |= Pkg.AM_SPACING;
			}
		}

		mnMask |= Pkg.AM_SPACING;
	}

	private void marginL (TextMeasurement oNewMarginL) {
		if ((! mpoAttr.marginLEnable()) || (! oNewMarginL.equals (mpoAttr.marginL()))) {
			mpoAttr.marginL (oNewMarginL);
			if (mpoDiffs != null) {
				mpoDiffs.marginL (oNewMarginL);
				mnDiffMask |= Pkg.AM_MARGINL;
			}
		}

		mnMask |= Pkg.AM_MARGINL;
	}

	private void marginR (TextMeasurement oNewMarginR) {
		if ((! mpoAttr.marginREnable()) || (! oNewMarginR.equals (mpoAttr.marginR()))) {
			mpoAttr.marginR (oNewMarginR);
			if (mpoDiffs != null) {
				mpoDiffs.marginR (oNewMarginR);
				mnDiffMask |= Pkg.AM_MARGINR;
			}
		}

		mnMask |= Pkg.AM_MARGINR;
	}

	private void justifyV (int eNewJustifyV) {
		if ((! mpoAttr.justifyVEnable()) || (eNewJustifyV != mpoAttr.justifyV())) {
			mpoAttr.justifyV (eNewJustifyV);
			if (mpoDiffs != null) {
				mpoDiffs.justifyV (eNewJustifyV);
				mnDiffMask |= Pkg.AM_JUSTIFYV;
			}
		}

		mnMask |= Pkg.AM_JUSTIFYV;
	}

	private void justifyH (int eNewJustifyH) {
		if ((! mpoAttr.justifyHEnable()) || (eNewJustifyH != mpoAttr.justifyH())) {
			mpoAttr.justifyH (eNewJustifyH);
			if (mpoDiffs != null) {
				mpoDiffs.justifyH (eNewJustifyH);
				mnDiffMask |= Pkg.AM_JUSTIFYH;
			}
		}

		mnMask |= Pkg.AM_JUSTIFYH;
	}

	private void radixOffset (TextMeasurement oNewRadixOffset) {
		if ((! mpoAttr.radixOffsetEnable()) || (! oNewRadixOffset.equals (mpoAttr.radixOffset()))) {
			mpoAttr.radixOffset (oNewRadixOffset);
			if (mpoDiffs != null) {
				mpoDiffs.radixOffset (oNewRadixOffset);
				mnDiffMask |= Pkg.AM_RADIXOFFSET;
			}
		}

		mnMask |= Pkg.AM_RADIXOFFSET;
	}

	private void radixPos (int nNewRadixPos) {
		if ((! mpoAttr.radixPosEnable()) || (nNewRadixPos != mpoAttr.radixPos())) {
			mpoAttr.radixPos (nNewRadixPos);
			if (mpoDiffs != null) {
				mpoDiffs.radixPos (nNewRadixPos);
				mnDiffMask |= Pkg.AM_RADIXPOS;
			}
		}

		mnMask |= Pkg.AM_RADIXPOS;
	}

	private void tabs (TextTabList oNewTabs) {
		mnMask |= Pkg.AM_TABS;

		if (mpoAttr.tabsEnable()) {
			if ((oNewTabs == mpoAttr.tabs()) || oNewTabs.equals (mpoAttr.tabs())) {
				return;
			}
		}

		mpoAttr.tabs (oNewTabs);

		if (mpoDiffs != null) {
			mpoDiffs.tabs (oNewTabs);
			mnDiffMask |= Pkg.AM_TABS;
		}
	}

	private void special (TextMeasurement oNewSpecial) {
		if ((! mpoAttr.specialEnable()) || (! oNewSpecial.equals (mpoAttr.special()))) {
			mpoAttr.special (oNewSpecial);
			if (mpoDiffs != null) {
				mpoDiffs.special (oNewSpecial);
				mnDiffMask |= Pkg.AM_SPECIAL;
			}
		}

		mnMask |= Pkg.AM_SPECIAL;
	}

	private void spaceBefore (TextMeasurement oNewSpaceBefore) {
		if ((! mpoAttr.spaceBeforeEnable()) || (! oNewSpaceBefore.equals (mpoAttr.spaceBefore()))) {
			mpoAttr.spaceBefore (oNewSpaceBefore);
			if (mpoDiffs != null) {
				mpoDiffs.spaceBefore (oNewSpaceBefore);
				mnDiffMask |= Pkg.AM_SPACEBEFORE;
			}
		}

		mnMask |= Pkg.AM_SPACEBEFORE;
	}

	private void spaceAfter (TextMeasurement oNewSpaceAfter) {
		if ((! mpoAttr.spaceAfterEnable()) || (! oNewSpaceAfter.equals (mpoAttr.spaceAfter()))) {
			mpoAttr.spaceAfter (oNewSpaceAfter);
			if (mpoDiffs != null) {
				mpoDiffs.spaceAfter (oNewSpaceAfter);
				mnDiffMask |= Pkg.AM_SPACEAFTER;
			}
		}

		mnMask |= Pkg.AM_SPACEAFTER;
	}

	private void invisible (boolean bNewInvisible) {
		if ((! mpoAttr.invisibleEnable()) || (bNewInvisible != mpoAttr.invisible())) {
			mpoAttr.invisible (bNewInvisible);
			if (mpoDiffs != null) {
				mpoDiffs.invisible (bNewInvisible);
				mnDiffMask |= Pkg.AM_INVISIBLE;
			}
		}

		mnMask |= Pkg.AM_INVISIBLE;
	}

	private void InvisChar (char cNewInvisChar) {
		if ((! mpoAttr.invisCharEnable()) || (cNewInvisChar != mpoAttr.invisChar())) {
			mpoAttr.invisChar (cNewInvisChar);
			if (mpoDiffs != null) {
				mpoDiffs.invisChar (cNewInvisChar);
				mnDiffMask |= Pkg.AM_INVISCHAR;
			}
		}

		mnMask |= Pkg.AM_INVISCHAR;
	}

	private void baselineShift (TextBaselineShift oShift) {
		if ((! mpoAttr.baselineShiftEnable()) || (! oShift.equals (mpoAttr.baselineShift()))) {
			mpoAttr.baselineShift (oShift);
			if (mpoDiffs != null) {
				mpoDiffs.baselineShift (oShift);
				mnDiffMask |= Pkg.AM_BASELINESHIFT;
			}
		}

		mnMask |= Pkg.AM_BASELINESHIFT;
	}

	private void locale (String sLocale) {
		if ((! mpoAttr.localeEnable()) || (! sLocale.equals (mpoAttr.locale()))) {
			mpoAttr.locale (sLocale);
			if (mpoDiffs != null) {
				mpoDiffs.locale (sLocale);
				mnDiffMask |= Pkg.AM_LOCALE;
			}
		}

		mnMask |= Pkg.AM_LOCALE;
	}

	private void digits (int eDigits) {
		if ((! mpoAttr.digitsEnable()) || (eDigits != mpoAttr.digits())) {
			mpoAttr.digits (eDigits);
			if (mpoDiffs != null) {
				mpoDiffs.digits (eDigits);
				mnDiffMask |= Pkg.AM_DIGITS;
			}
		}

		mnMask |= Pkg.AM_DIGITS;
	}

	private void direction (int eDirection) {
		if ((! mpoAttr.directionEnable()) || (eDirection != mpoAttr.direction())) {
			mpoAttr.direction (eDirection);
			if (mpoDiffs != null) {
				mpoDiffs.direction (eDirection);
				mnDiffMask |= Pkg.AM_DIRECTION;
			}
		}

		mnMask |= Pkg.AM_DIRECTION;
	}

	private void paraDirection (int eParaDirection) {
		if ((! mpoAttr.paraDirectionEnable()) || (eParaDirection != mpoAttr.paraDirection())) {
			mpoAttr.paraDirection (eParaDirection);
			if (mpoDiffs != null) {
				mpoDiffs.paraDirection (eParaDirection);
				mnDiffMask |= Pkg.AM_PARA_DIRECTION;
			}
		}

		mnMask |= Pkg.AM_PARA_DIRECTION;
	}

	protected void layoutOrientation (int eLayoutOrientation) {
		if ((! mpoAttr.layoutOrientationEnable()) || (eLayoutOrientation != mpoAttr.layoutOrientation())) {
			mpoAttr.layoutOrientation (eLayoutOrientation);
			if (mpoDiffs != null) {
				mpoDiffs.layoutOrientation (eLayoutOrientation);
				mnDiffMask |= Pkg.AM_LAYOUT_ORIENTATION;
			}
		}

		mnMask |= Pkg.AM_LAYOUT_ORIENTATION;
	}

	private void ligature (int eLigature) {
		if ((! mpoAttr.ligatureEnable()) || (eLigature != mpoAttr.ligature())) {
			mpoAttr.ligature (eLigature);
			if (mpoDiffs != null) {
				mpoDiffs.ligature (eLigature);
				mnDiffMask |= Pkg.AM_LIGATURE;
			}
		}

		mnMask |= Pkg.AM_LIGATURE;
	}

	protected void charSpacing (TextMeasurement nCharSpacing) {
		if ((! mpoAttr.charSpacingEnable()) || (nCharSpacing != mpoAttr.charSpacing())) {
			mpoAttr.charSpacing (nCharSpacing);
			if (mpoDiffs != null) {
				mpoDiffs.charSpacing (nCharSpacing);
				mnDiffMask |= Pkg.AM_CHAR_SPACING;
			}
		}

		mnMask |= Pkg.AM_CHAR_SPACING;
	}

	protected void wordSpacing (TextMeasurement nWordSpacing) {
		if ((! mpoAttr.wordSpacingEnable()) || (nWordSpacing != mpoAttr.wordSpacing())) {
			mpoAttr.wordSpacing (nWordSpacing);
			if (mpoDiffs != null) {
				mpoDiffs.wordSpacing (nWordSpacing);
				mnDiffMask |= Pkg.AM_WORD_SPACING;
			}
		}

		mnMask |= Pkg.AM_WORD_SPACING;
	}

	protected void kerning (boolean bNewKerning) {
		if ((! mpoAttr.kerningEnable()) || (bNewKerning != mpoAttr.kerning())) {
			mpoAttr.kerning (bNewKerning);
			if (mpoDiffs != null) {
				mpoDiffs.kerning (bNewKerning);
				mnDiffMask |= Pkg.AM_KERNING;
			}
		}

		mnMask |= Pkg.AM_KERNING;
	}

	protected void hyphLevel (int eNewHyphLevel) {
		if ((! mpoAttr.hyphLevelEnable()) || (eNewHyphLevel != mpoAttr.hyphLevel())) {
			mpoAttr.hyphLevel (eNewHyphLevel);
			if (mpoDiffs != null) {
				mpoDiffs.hyphLevel (eNewHyphLevel);
				mnDiffMask |= Pkg.AM_HYPH_LEVEL;
			}
		}

		mnMask |= Pkg.AM_HYPH_LEVEL;
	}

	protected void hyphMinWord (int nNewHyphMinWord) {
		if ((! mpoAttr.hyphMinWordEnable()) || (nNewHyphMinWord != mpoAttr.hyphMinWord())) {
			mpoAttr.hyphMinWord (nNewHyphMinWord);
			if (mpoDiffs != null) {
				mpoDiffs.hyphMinWord (nNewHyphMinWord);
				mnDiffMask |= Pkg.AM_HYPH_MIN_WORD;
			}
		}

		mnMask |= Pkg.AM_HYPH_MIN_WORD;
	}

	protected void hyphMinPrefix (int nNewHyphMinPrefix) {
		if ((! mpoAttr.hyphMinPrefixEnable()) || (nNewHyphMinPrefix != mpoAttr.hyphMinPrefix())) {
			mpoAttr.hyphMinPrefix (nNewHyphMinPrefix);
			if (mpoDiffs != null) {
				mpoDiffs.hyphMinPrefix (nNewHyphMinPrefix);
				mnDiffMask |= Pkg.AM_HYPH_MIN_PREFIX;
			}
		}

		mnMask |= Pkg.AM_HYPH_MIN_PREFIX;
	}

	protected void hyphMinSuffix (int nNewHyphMinSuffix) {
		if ((! mpoAttr.hyphMinSuffixEnable()) || (nNewHyphMinSuffix != mpoAttr.hyphMinSuffix())) {
			mpoAttr.hyphMinSuffix (nNewHyphMinSuffix);
			if (mpoDiffs != null) {
				mpoDiffs.hyphMinSuffix (nNewHyphMinSuffix);
				mnDiffMask |= Pkg.AM_HYPH_MIN_SUFFIX;
			}
		}

		mnMask |= Pkg.AM_HYPH_MIN_SUFFIX;
	}

	protected void hyphMaxLines (int nNewHyphMaxLines) {
		if ((! mpoAttr.hyphMaxLinesEnable()) || (nNewHyphMaxLines != mpoAttr.hyphMaxLines())) {
			mpoAttr.hyphMaxLines (nNewHyphMaxLines);
			if (mpoDiffs != null) {
				mpoDiffs.hyphMaxLines (nNewHyphMaxLines);
				mnDiffMask |= Pkg.AM_HYPH_MAX_LINES;
			}
		}

		mnMask |= Pkg.AM_HYPH_MAX_LINES;
	}

	protected void hyphSuppressNames (boolean bNewHyphSuppressNames) {
		if ((! mpoAttr.hyphSuppressNamesEnable()) || (bNewHyphSuppressNames != mpoAttr.hyphSuppressNames())) {
			mpoAttr.hyphSuppressNames (bNewHyphSuppressNames);
			if (mpoDiffs != null) {
				mpoDiffs.hyphSuppressNames (bNewHyphSuppressNames);
				mnDiffMask |= Pkg.AM_HYPH_SUPPRESS_NAMES;
			}
		}

		mnMask |= Pkg.AM_HYPH_SUPPRESS_NAMES;
	}

	protected void hyphSuppressAcronyms (boolean bNewHyphSuppressAcronyms) {
		if ((! mpoAttr.hyphSuppressAcronymsEnable()) || (bNewHyphSuppressAcronyms != mpoAttr.hyphSuppressAcronyms())) {
			mpoAttr.hyphSuppressAcronyms (bNewHyphSuppressAcronyms);
			if (mpoDiffs != null) {
				mpoDiffs.hyphSuppressAcronyms (bNewHyphSuppressAcronyms);
				mnDiffMask |= Pkg.AM_HYPH_SUPPRESS_ACRONYMS;
			}
		}

		mnMask |= Pkg.AM_HYPH_SUPPRESS_ACRONYMS;
	}

	protected void leaderPattern (int eNewLeaderPattern) {
		if ((! mpoAttr.leaderPatternEnable()) || (eNewLeaderPattern != mpoAttr.leaderPattern())) {
			mpoAttr.leaderPattern (eNewLeaderPattern);
			if (mpoDiffs != null) {
				mpoDiffs.leaderPattern (eNewLeaderPattern);
				mnDiffMask |= Pkg.AM_LEADER_PATTERN;
			}
		}

		mnMask |= Pkg.AM_LEADER_PATTERN;
	}

	protected void leaderPatternWidth (TextMeasurement oNewLeaderPatternWidth) {
		if ((! mpoAttr.leaderPatternWidthEnable()) || (oNewLeaderPatternWidth != mpoAttr.leaderPatternWidth())) {
			mpoAttr.leaderPatternWidth (oNewLeaderPatternWidth);
			if (mpoDiffs != null) {
				mpoDiffs.leaderPatternWidth (oNewLeaderPatternWidth);
				mnDiffMask |= Pkg.AM_LEADER_PATTERN_WIDTH;
			}
		}

		mnMask |= Pkg.AM_LEADER_PATTERN_WIDTH;
	}

	protected void leaderAlign (int eNewLeaderAlign) {
		if ((! mpoAttr.leaderAlignEnable()) || (eNewLeaderAlign != mpoAttr.leaderAlign())) {
			mpoAttr.leaderAlign (eNewLeaderAlign);
			if (mpoDiffs != null) {
				mpoDiffs.leaderAlign (eNewLeaderAlign);
				mnDiffMask |= Pkg.AM_LEADER_ALIGN;
			}
		}

		mnMask |= Pkg.AM_LEADER_ALIGN;
	}

	protected void leaderContent (TextStream oNewLeaderContent) {
		if ((! mpoAttr.leaderContentEnable()) || (oNewLeaderContent != mpoAttr.leaderContent())) {
			mpoAttr.leaderContent (oNewLeaderContent);
			if (mpoDiffs != null) {
				mpoDiffs.leaderContent (oNewLeaderContent);
				mnDiffMask |= Pkg.AM_LEADER_CONTENT;
			}
		}

		mnMask |= Pkg.AM_LEADER_CONTENT;
	}

	protected void ruleStyle (int eNewRuleStyle) {
		if ((! mpoAttr.ruleStyleEnable()) || (eNewRuleStyle != mpoAttr.ruleStyle())) {
			mpoAttr.ruleStyle (eNewRuleStyle);
			if (mpoDiffs != null) {
				mpoDiffs.ruleStyle (eNewRuleStyle);
				mnDiffMask |= Pkg.AM_RULE_STYLE;
			}
		}

		mnMask |= Pkg.AM_RULE_STYLE;
	}

	protected void ruleThickness (TextMeasurement oNewRuleThickness) {
		if ((! mpoAttr.ruleThicknessEnable()) || (oNewRuleThickness != mpoAttr.ruleThickness())) {
			mpoAttr.ruleThickness (oNewRuleThickness);
			if (mpoDiffs != null) {
				mpoDiffs.ruleThickness (oNewRuleThickness);
				mnDiffMask |= Pkg.AM_RULE_THICKNESS;
			}
		}

		mnMask |= Pkg.AM_RULE_THICKNESS;
	}

	private void disableNotPresent () {
		disableNotPresent (mpoAttr, mnMask);
	}

	private void disableNotPresentDiffs () {
		if (mpoDiffs != null) {
			disableNotPresent (mpoDiffs, mnDiffMask);
		}
	}

	private void disableNotPresent (TextAttr poAttr, long nMask) {
		if ((nMask & Pkg.AM_FONT) == 0) {
			poAttr.fontEnable (false);
		}
		if ((nMask & Pkg.AM_TYPEFACE) == 0) {
			poAttr.typefaceEnable (false);
		}
		if ((nMask & Pkg.AM_SIZE) == 0) {
			poAttr.sizeEnable (false);
		}
		if ((nMask & Pkg.AM_WEIGHT) == 0) {
			poAttr.weightEnable (false);
		}
		if ((nMask & Pkg.AM_ITALIC) == 0) {
			poAttr.italicEnable (false);
		}

		if ((nMask & Pkg.AM_UNDERLINE) == 0) {
			poAttr.underlineEnable (false);
		}
		if ((nMask & Pkg.AM_OVERLINE) == 0) {
			poAttr.overlineEnable (false);
		}
		if ((nMask & Pkg.AM_LINE_THROUGH) == 0) {
			poAttr.strikeoutEnable (false);
		}
		if ((nMask & Pkg.AM_TEXT_CONTEXT) == 0) {
			poAttr.textContextEnable (false);
		}
		if ((nMask & Pkg.AM_COLOUR) == 0) {
			poAttr.colourEnable (false);
		}
		if ((nMask & Pkg.AM_COLOURBG) == 0) {
			poAttr.colourBgEnable (false);
		}
		if ((nMask & Pkg.AM_STYLE) == 0) {
			poAttr.styleEnable (false);
		}
		if ((nMask & Pkg.AM_SHADE) == 0) {
			poAttr.shadeEnable (false);
		}
		if ((nMask & Pkg.AM_SHADESCALE) == 0) {
			poAttr.shadeScaleEnable (false);
		}
		if ((nMask & Pkg.AM_GRAPHIC_CONTEXT) == 0) {
			poAttr.graphicContextEnable (false);
		}

		if ((nMask & Pkg.AM_TRANSPARENT) == 0) {
			poAttr.transparentEnable (false);
		}
		if ((nMask & Pkg.AM_SPACING) == 0) {
			poAttr.spacingEnable (false);
		}
		if ((nMask & Pkg.AM_MARGINL) == 0) {
			poAttr.marginLEnable (false);
		}
		if ((nMask & Pkg.AM_MARGINR) == 0) {
			poAttr.marginREnable (false);
		}
		if ((nMask & Pkg.AM_JUSTIFYV) == 0) {
			poAttr.justifyVEnable (false);
		}
		if ((nMask & Pkg.AM_JUSTIFYH) == 0) {
			poAttr.justifyHEnable (false);
		}
		if ((nMask & Pkg.AM_RADIXOFFSET) == 0) {
			poAttr.radixOffsetEnable (false);
		}
		if ((nMask & Pkg.AM_RADIXPOS) == 0) {
			poAttr.radixPosEnable (false);
		}
		if ((nMask & Pkg.AM_TABS) == 0) {
			poAttr.tabsEnable (false);
		}
		if ((nMask & Pkg.AM_SPECIAL) == 0) {
			poAttr.specialEnable (false);
		}
		if ((nMask & Pkg.AM_SPACEBEFORE) == 0) {
			poAttr.spaceBeforeEnable (false);
		}
		if ((nMask & Pkg.AM_SPACEAFTER) == 0) {
			poAttr.spaceAfterEnable (false);
		}
		if ((nMask & Pkg.AM_INVISIBLE) == 0) {
			poAttr.invisibleEnable (false);
		}
		if ((nMask & Pkg.AM_INVISCHAR) == 0) {
			poAttr.invisCharEnable (false);
		}
		if ((nMask & Pkg.AM_BASELINESHIFT) == 0) {
			poAttr.baselineShiftEnable (false);
		}

		if ((nMask & Pkg.AM_LOCALE) == 0) {
			poAttr.localeEnable (false);
		}
		if ((nMask & Pkg.AM_DIGITS) == 0) {
			poAttr.digitsEnable (false);
		}
		if ((nMask & Pkg.AM_DIRECTION) == 0) {
			poAttr.directionEnable (false);
		}
		if ((nMask & Pkg.AM_PARA_DIRECTION) == 0) {
			poAttr.paraDirectionEnable (false);
		}
		if ((nMask & Pkg.AM_LAYOUT_ORIENTATION) == 0) {
			poAttr.layoutOrientationEnable (false);
		}
		if ((nMask & Pkg.AM_LIGATURE) == 0) {
			poAttr.ligatureEnable (false);
		}

		if ((nMask & Pkg.AM_CHAR_SPACING) == 0) {
			poAttr.charSpacingEnable (false);
		}
		if ((nMask & Pkg.AM_WORD_SPACING) == 0) {
			poAttr.wordSpacingEnable (false);
		}
		if ((nMask & Pkg.AM_KERNING) == 0) {
			poAttr.kerningEnable (false);
		}

		if ((nMask & Pkg.AM_HYPH_LEVEL) == 0) {
			poAttr.hyphLevelEnable (false);
		}
		if ((nMask & Pkg.AM_HYPH_MIN_WORD) == 0) {
			poAttr.hyphMinWordEnable (false);
		}
		if ((nMask & Pkg.AM_HYPH_MIN_PREFIX) == 0) {
			poAttr.hyphMinPrefixEnable (false);
		}
		if ((nMask & Pkg.AM_HYPH_MIN_SUFFIX) == 0) {
			poAttr.hyphMinSuffixEnable (false);
		}
		if ((nMask & Pkg.AM_HYPH_MAX_LINES) == 0) {
			poAttr.hyphMaxLinesEnable (false);
		}
		if ((nMask & Pkg.AM_HYPH_SUPPRESS_NAMES) == 0) {
			poAttr.hyphSuppressNamesEnable (false);
		}
		if ((nMask & Pkg.AM_HYPH_SUPPRESS_ACRONYMS) == 0) {
			poAttr.hyphSuppressAcronymsEnable (false);
		}

		if ((nMask & Pkg.AM_LEADER_PATTERN) == 0) {
			poAttr.leaderPatternEnable (false);
		}
		if ((nMask & Pkg.AM_LEADER_PATTERN_WIDTH) == 0) {
			poAttr.leaderPatternWidthEnable (false);
		}
		if ((nMask & Pkg.AM_LEADER_ALIGN) == 0) {
			poAttr.leaderAlignEnable (false);
		}
		if ((nMask & Pkg.AM_LEADER_CONTENT) == 0) {
			poAttr.leaderContentEnable (false);
		}
		if ((nMask & Pkg.AM_RULE_STYLE) == 0) {
			poAttr.ruleStyleEnable (false);
		}
		if ((nMask & Pkg.AM_RULE_THICKNESS) == 0) {
			poAttr.ruleThicknessEnable (false);
		}
	}
}
