package com.adobe.xfa.text;

/**
 * @exclude from published api.
 */

class GlyphLoc extends DispMapItem {
	private int mnGlyphIndex;

	GlyphLoc () {
	}

	GlyphLoc (int nGlyphIndex) {
		mnGlyphIndex = nGlyphIndex;
	}

	GlyphLoc (GlyphLoc source) {
		copyFrom (source);
	}

	GlyphLoc (GlyphLoc source, int index, int length) {
		super (index, length);
		mnGlyphIndex = source.mnGlyphIndex;
	}

	GlyphLoc (int glyphIndex, int mapIndex, int mapLength) {
		super (mapIndex, mapLength);
		mnGlyphIndex = glyphIndex;
	}

	int getGlyphIndex () {
		return mnGlyphIndex;
	}

	void setGlyphIndex (int nGlyphIndex) {
		mnGlyphIndex = nGlyphIndex;
	}

	void copyFrom (GlyphLoc source) {
		super.copyFrom (source);
		mnGlyphIndex = source.mnGlyphIndex;
	}

	GlyphLoc g () {
		return this;
	}

	DispMapItem cloneMapItem (int index, int length) {
		return new GlyphLoc (this, index, length);
	}

	void copyFrom (DispMapItem source) {
		assert (source instanceof GlyphLoc);
		copyFrom ((GlyphLoc) source);
	}
}
