/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;


/**
 * A mutable holder class to represent an <i>int</i> value.
 * IntegerHolder objects are useful as out and inout parameters.
 *
 * @exclude from public api.
 */
public final class IntegerHolder {

	/**
	 * Instantiates an IntegerHolder object with the initial value 0.
	 */
	public IntegerHolder() {
	}

	/**
	 * Instantiates an IntegerHolder object with the initial value given.
	 *
	 * @param value the initial value.
	 */
	public IntegerHolder(int value) {
		this.value = value;
	}

	/**
	 * The int value held by this object.
	 */
	public int value;

}
