// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2012 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================
package com.adobe.xmp.core.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;

import org.xml.sax.InputSource;

import com.adobe.xmp.core.XMPException;
import com.adobe.xmp.core.XMPMetadata;
import com.adobe.xmp.core.parser.impl.ParserImpl;


/**
 * RDF/XML Implementation of XMPParser-Interface,
 * it only delegates to the implementation.
 */
public class RDFXMLParser implements XMPParser 
{
	/**
	 * @see XMPParser#parse(InputStream, Map)
	 */
	public XMPMetadata parse(InputStream input, Map<String, Object> parseContext) throws XMPException
	{
		// TOTRACK: the inputStream has to be checked for disallowed <!DOCTYPE
		return ParserImpl.parse (new InputSource(input), parseContext);
	}
	

	/**
	 * @see XMPParser#parse(String, Map)
	 */
	public XMPMetadata parse(String input, Map<String, Object> parseContext) throws XMPException
	{
		return ParserImpl.parse(
			new InputSource(new CheckDocTypeReader(new StringReader(input))), parseContext);
	}

	
	/**
	 * @see XMPParser#parse(byte[], Map)
	 */
	public XMPMetadata parse(byte[] input, Map<String, Object> parseContext) throws XMPException
	{
		// TOTRACK: check for disallowed <!DOCTYPE, see above
		return ParserImpl.parse(
			new InputSource(new ByteArrayInputStream(input)), parseContext);
	}
}
