/*
 * File: DatatypeInfo.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xmp.schema.rng.model;

import java.util.HashMap;
import java.util.Map;

/**
 * This class models data types of values defined in input RelaxNG schema
 * @author pwollek
 */
public class DatatypeInfo
{
	static final Map<String, String> kXMLDatatypes = new HashMap<String, String>();
	
	static {
		// XML Schema type: Model type:
			kXMLDatatypes.put("text", "Text");
			kXMLDatatypes.put("string", "Text");
			kXMLDatatypes.put("boolean", "Boolean");
			kXMLDatatypes.put("float", "Real");
			kXMLDatatypes.put("double", "Real");
			kXMLDatatypes.put("decimal", "Real");
			kXMLDatatypes.put("integer", "Integer");
			kXMLDatatypes.put("long", "Integer");
			kXMLDatatypes.put("int", "Integer");
			kXMLDatatypes.put("short", "Integer");
			kXMLDatatypes.put("byte", "Integer");
			kXMLDatatypes.put("float", "Real");
			kXMLDatatypes.put("float", "Real");
			kXMLDatatypes.put("float", "Real");
	}

	private final String mName;

	private final boolean mRaw;

	/**
	 * 
	 * Constructs a new DatatypeInfo.
	 *
	 * @param name name of data type
	 */
	public DatatypeInfo(String name)
	{
		mName = this.getModelTypeName(name);
		mRaw = false;
	}

	/**
	 * 
	 * Constructs a new DatatypeInfo.
	 *
	 * @param name name of data type
	 * @param raw  If this is a raw data type defined in the RelaxNG spec 
	 */
	public DatatypeInfo(String name, boolean raw)
	{
		if(raw)
		{
			// Check if the type name is actually among the raw types.
			// If no then create set the type as text
			if(! kXMLDatatypes.containsKey(name))
			{
				mName = "Text";
				mRaw = false;
			}
			else
			{
				mName = getModelTypeName(name);
				mRaw = raw;
			}
		}
		else
		{
			mName = getModelTypeName(name);
			mRaw = raw;
		}
		
		
	}

	/**
	 * @return the mName
	 */
	public String getName()
	{
		return mName;
	}

	/**
	 * @return true if this is a raw type, else false
	 */
	public boolean isRawType()
	{
		return mRaw;
	}

	private String getModelTypeName(String name)
	{
		String ret = name;

		if (!kXMLDatatypes.containsValue(name) && kXMLDatatypes.containsKey(name))
		{
			ret = kXMLDatatypes.get(name);
		}

		return ret;
	}
	
	@Override
	public String toString()
	{
		StringBuilder str = new StringBuilder();
		str.append("(Name : ").append(mName).append(") ");
		return str.toString();
	}
}
