/*
 * File: RNGUnexpectedElementFoundException.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.xmp.schema.rng.parser.exceptions;

/**
 * At each state of traversing the RelaxNG data model, only a few element are expected for the data model to represent
 * valid XMP schemas. If an unexpected rng element is encountered while schema parsing this exception is thrown.
 * 
 * @author hraghav
 */
public class RNGUnexpectedElementFoundException extends RNGParseException
{
	private static final long serialVersionUID = -2340408528814646571L;

	/**
	 * 
	 * Constructs a new RNGUnexpectedElementFoundException.
	 * 
	 * @param string
	 *            the detail message
	 */
	public RNGUnexpectedElementFoundException(String string)
	{
		super(string);
	}

}
