package com.day.cq.analytics.sitecatalyst.util;

import com.adobe.granite.crypto.CryptoException;
import org.apache.sling.api.resource.LoginException;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@ProviderType
public interface TokenProviderProxy {
    @Nullable
    String getAccessToken(@Nonnull String name) throws CryptoException, IOException, LoginException;

    @Nonnull
    Set<Map<String, String>> getTokenProvidersInfo();

    @Nullable
    String getApikey(String name);

    @Nullable
    String getServicePid(String name);
}

