/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.ArrayList;
import java.util.List;

/**
 * Contains multiple {@code Step}s and a {@code Conversion}
 * 
 * @see <a href="https://developer.omniture.com/en_US/documentation/test-target/r-performance-report"> Adobe Target
 *      performance report API</a>
 */
public class Recipe {

    public static final String TRAFFIC_TYPE_TESTING = "TESTING";
    public static final String TRAFFIC_TYPE_TOTAL = "TOTAL";

    private final String id;
    private final String name;
    // String instead of enum since I could not find a clear enumeration of all possible values
    private final String trafficType;
    private final Conversion conversion;

    private final List<Step> steps = new ArrayList<Step>();

    public Recipe(String id, String name, String trafficType, Conversion conversion) {
        this.id = id;
        this.name = name;
        this.trafficType = trafficType;
        this.conversion = conversion;
    }

    public void addStep(Step step) {
        steps.add(step);
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getTrafficType() {
        return trafficType;
    }

    public Conversion getConversion() {
        return conversion;
    }

    public List<Step> getSteps() {
        return steps;
    }

    public int getStepValueByName(String stepName) {

        for (Step step : steps)
            if (stepName.equals(step.getName()))
                return step.getCount().intValue();

        return 0;
    }

    public int getConversionCount() {
        return conversion != null ? conversion.getCount().intValue() : 0;
    }
}