/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.thumbnail;

import javax.jcr.Node;

import org.apache.sling.api.resource.Resource;

import aQute.bnd.annotation.ProviderType;


/**
 * Provider that returns registered predicates.
 */
@ProviderType
public interface ThumbnailProviderManager {

    /**
     * Returns the registered thumbnail provider.
     *
     * @param node node for which a thumbnail is requested
     * @return thumbnail provider or <code>null</code>
     * @deprecated use {@link #getThumbnailProvider(Resource)} instead
     */
    ThumbnailProvider getThumbnailProvider(Node node);


    /**
     * Returns the registered thumbnail provider.
     *
     * @param resource resource for which a thumbnail is requested
     * @return thumbnail provider or <code>null</code>
     */
    ThumbnailProvider getThumbnailProvider(Resource resource);

}
