package com.day.cq.dam.api.s7dam.utils;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The SampleUtils service provides calls to prepare DM sample assets and
 * presets for DMS7 integration.
 */
@ProviderType
public interface SampleUtils {

    /**
     * Copy DM sample assets from standard location to targetFolder for sync.
     *
     * The standard location is <code>/libs/dam/preview/</code>.
     *
     * @param targetFolder target folder path to which the DM sample assets are to be copied to
     * @throws Exception error which copying DM sample assets from standard location to targetFolder for sync.
     */
    void processSampleAssets(String targetFolder) throws Exception;

    /**
     * Iterate viewer presets in standard location and copy to related CSS and
     * artwork to targetFolder for sync. Update viewer preset nodes to point to
     * new CSS location.
     *
     * The standard location is <code>/etc/dam/presets/viewer/</code>.
     *
     * @param targetFolder target folder path to which the CSS and artwork are to be copied to
     * @throws Exception error which iterating and copying data from standard location to targetFolder for sync.
     */
    void processPresetAssets(String targetFolder) throws Exception;
}
