/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2019 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.dam.commons.util;

import org.osgi.annotation.versioning.ProviderType;

/**
 * This class provides various utility methods pertaining to DAM Mime Type Service Implementation.
 */

@ProviderType
public interface DamMimeUtils {
    /**
     * This method updates the status of 'cq.dam.allow.all.mime' property
     * of "Day CQ DAM Asset Upload Restriction" OSGi configuration in
     * the DamMimeUtil service
     * @param val the value to update service with
     */
    public void setAllowAllMimeAttribute(boolean val);

    /**
     * This method updates the status of 'cq.dam.detect.asset.mime.from.content' property
     * of "Day CQ DAM Mime Type Service" OSGi configuration
     * @param val the value to update service with
     */
    public void setDetectMimeFromContent(boolean val);

    /**
     * This method updates the status of 'cq.dam.allowed.asset.mimes' property
     * of "Day CQ DAM Asset Upload Restriction" OSGi configuration in
     * the DamMimeUtil service
     * @param mimeList an array of regex-strings specifying supported/whitelisted MIMEs
     */
    public void setSupportedMimeTypes(String[] mimeList);

    /**
     * Based on current state of the service, this method evaluates if currently provided
     * MIME (as detected from asset name, and optionally asset content) is allowed for upload
     * or not
     * @param nameMimeType MIME of the asset as detected from its name
     * @param contentMimeType MIME of the asset as detected from its content
     *        (can be null, but if present is preferred over nameMimeType)
     * @return true if upload is allowed, false otherwise
     */
    public boolean isAllowedMimeType(String nameMimeType, String contentMimeType);

    /**
     * Returns of content-based-MIME-detection is enabled
     * @return true if enabled, false otherwise
     */
    public boolean getDetectMimeFromContent();
}
