/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.handler.gibson.fontmanager;

public class FontManagerException extends RuntimeException {
    /**
     * exception related to font directories
     */
    public static final int FONTMGR_FONTDIREXCEPTION = 1002;

    /**
     * exception while loading fonts
     */
    public static final int FONTMGR_FONTLOADINGEXCEPTION = 1003;

    /**
     * gibson PDFFontException
     */
    public static final int PDFFONTEXCEPTION = 1004;

    private int code;

    public FontManagerException(int code, String message) {
        super(message);
        this.code = code;
    }

    public FontManagerException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public String getMessage() {

        return getString(code) + " ==> " + super.getMessage();
    }

    private String getString(int code) {
        switch (code) {
            case PDFFONTEXCEPTION:
                return "Gibson PDFFontException";
            case FONTMGR_FONTLOADINGEXCEPTION:
                return "Exception while loading fonts";
            case FONTMGR_FONTDIREXCEPTION:
                return "Exception related to font directories";
        }
        return "";
    }
}
