/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.constants;

/**
 * defines constants, such as node types and property names for all things scene7.
 */
public class Scene7Constants {

    private Scene7Constants() {
        // static access only
    }

    // ----------------------------------------------< s7 asset properties >

    /**
     * S7 property - cloud configuration referenced for upload
     */
    public static final String PN_S7_CLOUDCONFIG_PATH = "dam:scene7CloudConfigPath";

    /**
     * S7 property - generated asset Name
     */
    public static final String PN_S7_NAME = "dam:scene7Name";

    /**
     * S7 property - generated Upload filename
     */
    public static final String PN_S7_UPLOAD_FILENAME = "dam:scene7UploadFileName";

    /**
     * S7 property - asset type
     */
    public static final String PN_S7_TYPE = "dam:scene7Type";

    /**
     * S7 property - Scene7 root ID
     */
    public final static String PN_S7_ROOT_ID = "dam:scene7RootID";

    /**
     * S7 property - S7 Asset handle
     */
    public static final String PN_S7_ASSET_ID = "dam:scene7ID";

    /**
     * S7 property - S7 Company Handle
     */
    public static final String PN_S7_COMPANY_ID = "dam:scene7CompanyID";

    /**
     * S7 property - S7 Asset specifier for Viewer components
     */
    public static final String PN_S7_FILE = "dam:scene7File";

    /**
     * S7 property - S7 Asset specifier for AVS container asset
     */
    public static final String PN_S7_FILE_AVS = "dam:scene7FileAvs";

    /**
     * S7 property - S7 upload/publish status (see values below)
     */
    public static final String PN_S7_FILE_STATUS = "dam:scene7FileStatus";

    /**
     * S7 property - S7 Folder in which the asset resides
     */
    public static final String PN_S7_FOLDER = "dam:scene7Folder";

    /**
     * S7 property - S7 Server
     */
    public static final String PN_S7_DOMAIN = "dam:scene7Domain";

    /**
     * S7 property - local upload complete time stamp
     */
    public static final String PN_S7_UPLOAD_TIMESTAMP = "dam:scene7UploadTimeStamp";
    /**
     * S7 property - publish time stamp
     */
    public static final String PN_S7_PUBLISH_TIMESTAMP = "dam:scene7PublishTimeStamp";

    /**
     * S7 property - publish user
     */
    public static final String PN_S7_PUBLISHED_BY = "dam:scene7PublishedBy";

    /**
     * S7 property - upload time stamp as recorded from scene7 server
     */
    public static final String PN_S7_JOB_STARTDATE = "dam:scene7JobStartDate";

    /**
     * S7 property - S7 server LastModified time stamp
     */
    public static final String PN_S7_LAST_MODIFIED = "dam:scene7LastModified";

    /**
     * S7 property - S7 WebServices server
     */
    public static final String PN_S7_API_SERVER = "dam:scene7APIServer";

    /**
     * S7 preview request token parameter name
     */
    public static final String PN_S7_PREVIEW_TOKEN_PARAM = "token";

    /**
     * S7 property - Set at folder metadata nodes, indicates whether sub folders should be included in publish/synchronization.
     */
    public static final String PN_S7_PUBLISH_SUBFOLDERS = "dam:scene7PublishSubFolders";

    public static final String PN_S7_ORIGINAL_PATH = "dam:scene7OriginalPath";

    public static final String PN_S7_ORIGINAL_FILE = "dam:scene7OriginalFile";

    /**
     * Property set at asset level, indicates whether an asset was processed in the current polling import run
     */
    public static final String PN_S7_IMPORT_PROCESSED = "dam:scene7ImportProcessed";

    public static final String PN_S7_TEMPLATE_PARAMS = "dam:scene7TemplateParameters";

    public static final String PN_S7_WIDTH = "dam:scene7Width";

    public static final String PN_S7_HEIGHT = "dam:scene7Height";

    // ----------------------------------------------< PN_S7_FILE_STATUS prop values >

    /**
     * S7 property value - Upload has started indicator
     */
    public static final String PV_S7_UPLOAD_START = "UploadStart";

    /**
     * S7 property value - Flag to indicate reupload of asset is required
     */
    public static final String PV_S7_NEEDS_REUPLOAD = "NeedsReupload";

    /**
     * S7 property value - Reprocess has started indicator
     */
    public static final String PV_S7_REPROCESS_START = "ReprocessStart";

    /**
     * S7 property value - reprocess to S7 has failed indicator
     */
    public static final String PV_S7_REPROCESS_FAILED = "ReprocessFailed";

    /**
     * S7 property value - Flag to indicate rename of asset is complete
     */
    public static final String PV_S7_RENAME_COMPLETE = "RenameComplete";

    /**
     * S7 property value - Publish to S7 is queued indicator
     */
    public static final String PV_S7_PUBLISH_QUEUED = "PublishQueued";

    /**
     * S7 property value - Publish to S7 has started indicator
     */
    public static final String PV_S7_PUBLISH_START = "PublishStart";

    /**
     * S7 property value - Publish to S7 has not completed indicator
     */
    public static final String PV_S7_PUBLISH_INCOMPLETE = "PublishIncomplete";

    /**
     * S7 property value - Publish to S7 has completed indicator
     */
    public static final String PV_S7_PUBLISH_COMPLETE = "PublishComplete";

    /**
     * S7 property value - Publish to S7 has failed indicator
     */
    public static final String PV_S7_PUBLISH_FAILED = "PublishFailed";

    /**
     * S7 property value - Upload to S7 has failed indicator
     */
    public static final String PV_S7_UPLOAD_FAILED = "UploadFailed";

    /**
     * S7 property value - Upload is not supported for this asset type   
     */
    public static final String PV_S7_PUBLISH_NOT_SUPPORTED = "NotSupported";

    /**
     * S7 property value - Upload is not enabled for this asset type
     */
    public static final String PV_S7_PUBLISH_NOT_ENABLED = "MimeTypeNotEnabled";

    /**
     * S7 cloud configuration root path
     */
    public static final String CLOUD_CONFIG_ROOT = "/etc/cloudservices/scene7";

    /**
     * DMS7 cloud configuration root path
     */
    public static final String DMS7_CLOUD_CONFIG_ROOT = "/etc/cloudservices/dmscene7";

    /**
     * S7 date format
     */
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    /**
     * S7 import queue name
     */
    public static final String JOB_IMPORT_QUEUE_NAME = "Scene7 Import Queue";

    /**
     * S7 import topic prefix
     */
    public static final String IMPORT_JOB_TOPIC_PREFIX = "com/dam/cq/scene7/importer/";

    /**
     * The S7 cloud config path property used when sending import job events
     */
    public static final String IMPORT_JOB_CONFIG = "scene7Config";

    /**
     * The Scene7 asset property used when sending import job events
     */
    public static final String IMPORT_JOB_ASSET = "scene7Asset";

    /**
     * Root path of the import queues configuration
     */
    public static final String IMPORT_JOB_QUEUE_CONFIG_FOLDER = "/apps/dam/config";

    /**
     * The polling importer configuration node name
     */
    public static final String S7_POLLING_IMPORTER_NODE_NAME = "pollConfig";

    /**
     * Polling importer property name for the disable running importer configuration flag
     */
    public static final String S7_POLLING_IMPORTER_CANCEL_RUNNING_JOB_PROPERTY = "cancelImporter";

    /**
     * Property indicating if the polling importer is enabled
     */
    public static final String S7_POLLING_IMPORTER_ENABLED_PROPERTY = "enabled";

    /**
     * Property indicating that a DAM asset was imported / reimported with the help of the Scene7 Polling Importer
     */
    public static final String S7_POLLING_IMPORTER_MARKER = "dam:scene7PollingImporterMarker";

    /**
     * Supported MIME type JCR property prefix used for Scene7 upload job
     * parameters
     */
    public static final String S7_MIME_TYPE_JOB_PARAM = "jobParam";

    /**
     * Supported MIME type JCR property prefix used for Scene7 upload job
     * parameters
     */
    public static final String S7_MIME_TYPE_ENABLED = "enabled";

    /**
     * Property indicating if DAM Scene7 publish state is currently pending
     */
    public static final String PN_S7_NEED_PUBLISH = "dam:scene7PublishPending";

    /**
     * Service user mapping used for Scene7 configuration services
     */
    public static final String S7_CONFIG_SERVICE = "scene7configservice";

    public static final String S7_CONFIG_WRITER_SERVICE = "s7-config-writer-service";

    /**
     * Service user mapping used for Scene7 asset services
     */
    public static final String S7_ASSET_SERVICE = "scene7assetservice";

    /**
     * Service user mapping used for Scene7 asset read operation
     */
    public static final String S7_ASSET_READER_SERVICE = "scene7-asset-reader-service";

    /**
     * Service user mapping used for Scene7 asset write operations
     */
    public static final String S7_ASSET_WRITER_SERVICE = "scene7-asset-writer-service";

    /**
     * Scene7 asset property keys
     */
    public enum Scene7AssetProperty {
        ASSET_TYPE_STRING, ASSET_SUBTYPE_STRING, SCENE7_ASSET_TYPE, ASSET_HANDLE, NAME, FILE_NAME, FOLDER, FOLDER_HANDLE, CREATED_BY, MODIFIED_BY, VIDEO_ENCODING_PRESET_ID, CREATED_DATE, MODIFIED_DATE, ORIGINAL_FILE, ORIGINAL_PATH, WIDTH, HEIGHT, URL_MODIFIER, READY_TO_PUBLISH, FILE_SIZE, VIEWER_PRESET_TYPE, VIEWER_PRESET_CONFIGURATION_SETTINGS, SUB_ASSETS, ORIGINATOR, SMART_CROP, USER_DATA, ASSET_PROPERTIES
    }

    /**
     * S7 property - S7 migrated asset status (Boolean)
     */
    public static final String PN_S7_MIGRATED_STATUS = "dam:DMMigrated";

}
