/*
 * ADOBE CONFIDENTIAL
 *   ___________________
 *
 *    Copyright 2012 Adobe Systems Incorporated
 *    All Rights Reserved.
 *
 *   NOTICE:  All information contained herein is, and remains
 *   the property of Adobe Systems Incorporated and its suppliers,
 *   if any.  The intellectual and technical concepts contained
 *   herein are proprietary to Adobe Systems Incorporated and its
 *   suppliers and are protected by trade secret or copyright law.
 *   Dissemination of this information or reproduction of this material
 *   is strictly forbidden unless prior written permission is obtained
 *   from Adobe Systems Incorporated.
 */
package com.day.cq.mcm.api.newsletter;

import com.day.cq.mailer.AuthorizableMailingList;
import com.day.cq.mailer.MailingStatus;
import com.day.cq.wcm.api.Page;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import java.net.URI;

public interface NewsletterEmailService {

    /**
     * Send the newsletter.
     *
     * @param newsletter
     *            The newsletter
     * @return <code>true</code> if the newsletter could be send; <code>false</code>
     *         otherwise.
     * @throws java.security.AccessControlException
     *             if the Session lacks the privilege to send
     * @throws javax.jcr.RepositoryException
     *             in case of error accessing the Repository
     */
    MailingStatus sendNewsletter(NewsLetter newsletter, ResourceResolver resourceResolver) throws RepositoryException;

    /**
     * Builds a {@link NewsLetter Newsletter} from the given {@link com.day.cq.wcm.api.Page Page}.<br>
     * The Page is considered to represent the content of the Newsletter<br>
     * Its up to the implementation what are the preconditions on processing the
     * Page.
     *
     * @param page
     *            containing the data of the Newsletter
     * @return the Newsletter build maybe <code>null</code> if the Resource is
     *         not suited to build a Newsletter
     * @throws RepositoryException
     *             in case of Exception accessing the Repository
     */
    NewsLetter buildNewsletter(Page page) throws RepositoryException;

    /**
     * Builds a Newsletter and take the URI to retrieve the content.
     *
     * @param resource
     *            to build Newsletter of
     * @param contentUri
     *            to take as host information to be shown in sent Newsletter
     * @return the Newsletter build
     * @throws RepositoryException
     *             in case of error accessing the Repository
     * @see #buildNewsletter(Page)
     */
    NewsLetter buildNewsletter(Resource resource, URI contentUri) throws RepositoryException;

    /**
     * Build a MailingList for the given group-name
     *
     * @param groupName
     *            to build a MailingList for
     * @param session
     *            to retrieve the List
     * @return the List build
     * @throws RepositoryException
     *             in case of error accessing the Repository
     */
    AuthorizableMailingList createMailingList(String groupName, Session session) throws RepositoryException;

    /**
     * Create a MailingList for testing. The aim is to have a Profile to use for
     * personalization and a {@link org.apache.jackrabbit.api.security.user.User User} to an e-mail
     * address to send the mail to. The Address has to be given with the
     * RequestParameter {@link com.day.cq.mcm.core.NewsletterHelper#PARAM_TEST_TO} or defaults to
     * the Request's User's primary Mail (e.g. ResourceResolver.adaptTo(User.class)). The Profile has to be
     * given by the RequestParameter named
     * {@link com.day.cq.mcm.core.NewsletterHelper#PARAM_TEST_PROFILE} and the Id as value.
     *
     * @param request
     *            to read the input from
     * @return a MailingList with on Recipient or <code>null</code> if
     *         parameters are not set
     * @throws RepositoryException
     *             in case of error accessing the Repository
     */
    AuthorizableMailingList createTestMailingList(SlingHttpServletRequest request) throws RepositoryException;

}
