/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.types;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

/**
 * Defines interface for all the tools that are supported by external mail provider. 
 * These tools are basically a mapping of a name with the corresponding HTML
 */
public interface EmailTools {

    /**
     * This function adds a tool mapping.
     * @param toolName name of the tool
     * @param toolHtml The HTML associated with the tool.
     * @param toolText The text associated with the tool.
     */
    public void addMapping(String toolName, String toolHtml, String toolText);
    
    /**
     * This method removes a tool mapping.
     * @param toolName the name of the tool.
     */
    public void removeMapping(String toolName);

    /**
     * This method returns a HTML mapping associated with the tool.
     * @param toolName name of the tool.
     * @return The HTMl mapping with the tool.
     */
    public String getHtmlMapping(String toolName);

    /**
     * This method returns all the tool-HTMl mappings.
     * @return a map containing tool name and HTML mapping.
     */
    public Map<String, String> getHtmlMappings();
    
    /**
     * This method returns the text mapping associated with the tool.
     * @param toolName the name of the tool.
     * @return The text associated with the tool.
     */
    public String getTextMapping(String toolName);

    /**
     * This method returns all tool-Text mappings.
     * @return A map containing tool name and text mapping.
     */
    public Map<String, String> getTextMappings();
}
