/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.personalization;

import com.day.text.Text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class ClientContextUtil {

    /**
     * Returns a list of plugins (paths to JS files) defined into specified locations. If 2 plugins have the same name,
     * list will contain the one in the last location.
     * @param resourceResolver Resource resolver
     * @param locations Locations where to search for plugins
     * @return a list of plugins path
     */
    public static List<String> getPlugins(ResourceResolver resourceResolver, String[] locations){
        Map<String,String> cache = new HashMap<String,String>();
        List<String> res = new ArrayList<String>();

        for(int i = 0; i < locations.length; i++) {
            Resource libPlugins = resourceResolver.getResource(locations[i]);

            if (libPlugins!=null) {
                Iterator<Resource> it = resourceResolver.listChildren(libPlugins);
                while (it.hasNext()) {
                    Resource plugin = it.next();
                    String name = Text.getName(plugin.getPath());
                    if( name.indexOf(".js") != -1) {
                        if( cache.containsKey(name)) {
                            res.remove(cache.get(name));
                        }
                        cache.put(name,plugin.getPath());
                        res.add(plugin.getPath());
                    }
                }
            }
        }
        return res;
    }

    /**
     * Returns a valid DOM id based on a path or a random string (replaces invalid characters by "_").
     * @param idToFilter A repository path or a random string
     * @return A valid DOM id or an empty string
     */
    public static String getId(String idToFilter) {
        if( idToFilter != null) {
            String id = idToFilter.replace('/','_');
            id = id.replace(':','_');
            id = id.replace(' ','_');
            return id;
        }
        return "";
    }
}
