/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.replication;

/**
 * Transport handler that supports polling of modified content that should be
 * reverse replicated.
 */
public interface PollingTransportHandler {

    /**
     * Poll modified content from the transport handler.
     *
     * @param ctx transport context
     * @param tx replication transaction
     * @param factory replication content factory
     * @return modified content
     *
     * @throws ReplicationException if a replication error occurs
     * @throws TransportException if the underlying transport receives an unexpected answer
     */
    ReverseReplication[] poll(TransportContext ctx, ReplicationTransaction tx, ReplicationContentFactory factory)
            throws ReplicationException;

}
