/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface provides additional functionality to aggregates.
 *
 * @since 5.5
 */
public interface AggregateExtensions {

    /**
     * <p>Aggregates the specified value.</p>
     *
     * <p>If an aggregate implements both {@link Aggregate} and {@link AggregateExtensions},
     * then this method is used instead of {@link Aggregate#aggregateValue(CellValue)}.</p>
     *
     * <p>Note that <code>report</code> may be <code>null</code> for compatibility reasons.
     * </p>
     *
     * @param valueToAggregate The value to aggregate
     * @param report The report the value is aggregated for
     */
    void aggregateValue(CellValue valueToAggregate, Report report);

}
