/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.reporting;

/**
 * This interface represents a filter used for reports.
 */
public interface Filter {

    /**
     * Gets the filter's ID.
     *
     * @return The filter ID
     */
    String getId();

    /**
     * Creates a {@link FilterSettings} object that is suitable for configuring the filter.
     *
     * @return The {@link FilterSettings} object
     */
    FilterSettings createSettings();

    /**
     * Configures the filter.
     *
     * @param settings the filter's settings
     */
    void configure(FilterSettings settings);

    /**
     * Checks if the filter is active.
     *
     * @return <code>true</code> if the filter is active
     */
    boolean isActive();

    /**
     * <p>Checks if the specified data row matches the filter (= should be included in the
     * result set due to current filter settings).</p>
     *
     * <p>Note that this method may only be called if <code>this.isActive() == true</code>.
     * </p>
     *
     * @param cellData The data to check
     * @return True if the data row matches the filter
     */
    boolean isMatching(CellValue cellData);

}
