/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security;

/**
 * Thrown on attempt to create an Authorizable with an ID that already is in use
 * by another {@link Authorizable Authorizable}
 *
 * @see UserManager
 * @deprecated cq 5.5
 */
public class AuthorizableExistsException extends RuntimeException {

    private static final long serialVersionUID = -7263229762693153522L;

    private final String id;

    public AuthorizableExistsException(String id) {
        this(id, null);
    }
    public AuthorizableExistsException(String id, Exception cause) {
    	/*" already exists"*/
        super("Err01", cause);
        this.id = id;
    }

    public String getID() {
        return id;
    }
}
