/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter;

/**
 * Exception to indicate the missing index.html entry in the design package.
 *
 * <p>
 * The design package must contain an index.html at archive root(This rule is
 * configurable via OSGi configuration. Please refer to the CanvasPageBuilder OSGi components).
 * In case the required HTML document is not found, this exception is raised.
 * </p>
 */
public class MissingHTMLException extends DesignImportException {

    /** Serial Version UID */
    private static final long serialVersionUID = 1263614485758696971L;

    public MissingHTMLException() {
    }

    public MissingHTMLException(String message) {
        super(message);
    }

    public MissingHTMLException(Throwable cause) {
        super(cause);
    }

    public MissingHTMLException(String message, Throwable cause) {
        super(message, cause);
    }

}
