/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.net.MalformedURLException;
import java.net.URL;

import javax.jcr.RepositoryException;

import org.xml.sax.Attributes;

/**
 * This tag handler is used to transform the src attribute within an iframe tag.
 *
 * <p>
 * Since the assets should continue to be referable, their src attribute values are prepended with the current design path. Note that design
 * path is where the assets are dumped during the import process.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.IFrameTagHandlerFactory
 */
public class IFrameTagHandler extends DefaultTagHandler {

    private String rawSrc;

    public String getRawSrc() {
        return rawSrc;
    }

    private String normalizedSrc;

    public boolean isRawSrcAbsolute() {
        return isAbsoluteUrl(rawSrc);
    }

    private boolean normalizationRequired = true;

    private String normalizationPrefix = "<%= currentDesign.getPath() %>/";

    public void setNormalizationPrefix(String normalizationPrefix) {
        this.normalizationPrefix = normalizationPrefix;
    }

    public boolean isNormalizationRequired() {
        return normalizationRequired;
    }

    public void setNormalizationRequired(boolean normalizationRequired) {
        this.normalizationRequired = normalizationRequired;
    }

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        super.beginHandling(uri, localName, qName, atts);

        // This tag handler is required to prepend the design path of the
        // current page ahead of the relative asset url since the assets are
        // all being dumped into the design path directory and stay no more
        // relative to the page HTML eventually produced.

        normalizedSrc = rawSrc = atts.getValue("src");

    }

    @Override
    protected String getStartTag(String uri, String localName, String qName, Attributes atts) {

        if (rawSrc != null) {
            if (!isRawSrcAbsolute() && isNormalizationRequired()) {
                normalizedSrc = normalizationPrefix + rawSrc;
            }
        }

        String startTag = "<" + localName.toLowerCase();
        String att = "";
        for (int i = 0; i < atts.getLength(); i++) {
            String attrName = atts.getLocalName(i);
            String attrValue = atts.getValue(i);
            if ("src".equalsIgnoreCase(attrName)) {
                att += " " + attrName + "=\"" + normalizedSrc + "\"";
            } else {
                att += " " + attrName + "=\"" + attrValue + "\"";
            }
        }
        startTag += att;
        startTag += ">";

        // Check if the asset was existent in the archive. If not, log a warning.
        try {
            if (!designImporterContext.designNode.hasNode(rawSrc)) {
                designImporterContext.importWarnings.add("Could not locate the referenced html '" + rawSrc + "' in the design package");
            }
        } catch (RepositoryException e) {
        }

        return startTag;
    }

    protected boolean isAbsoluteUrl(String url) {
        try {
            new URL(url);
            return true;
        } catch (MalformedURLException e) {
            return false;
        }
    }
}