/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.wcm.designimporter.parser.taghandlers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.util.TagUtils;

/**
 * This tag handler is used to bypass the script tags with type attribute defined
 * different from text/javascript or application/javascript. This is useful for preserving
 * client templates that are often specified within tags like < script type="text/x-template" >
 *
 * <p>
 * This tag handler is registered against the markup of type < script type="text/template" >. That implies
 * this tag handler will come into action whenever the design importer framework
 * encounters an HTML tag matching the rule this handler is defined against.
 * </p>
 *
 * @see com.day.cq.wcm.designimporter.parser.taghandlers.factory.NonScriptTagHandlerFactory
 */
public class NonScriptTagHandler extends AbstractTagHandler {

    private Attributes atts;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        this.atts = atts;
    }

    @Override
    public void endHandling(String uri, String localName, String qName) {
        String startTag = getStartTag(uri, localName, qName, atts);
        htmlBuffer.insert(0, startTag);
        String endTag = TagUtils.getMatchingEndTag(startTag);
        htmlBuffer.append(endTag);
    }

    protected String getStartTag(String uri, String localName, String qName, Attributes atts) {
        return TagUtils.getStartTag(uri, localName, qName, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        if (delegate != null) {
            delegate.characters(ch, start, length);
        } else {
            String chars = new String(ch).substring(start, start + length)/* .replace('\n', ' ').replace('\t', ' ').trim() */;
            if (chars.length() > 0) {
                htmlBuffer.append((chars));
            }
        }
    }

}
