/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 1997 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.crx.statistics.keyword;

import com.day.crx.statistics.Report;

import javax.jcr.Session;
import javax.jcr.RepositoryException;
import javax.jcr.PathNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;

/**
 * <code>ClearKeywordsReport</code> implements a report that removes all
 * keyword properties.
 *
 * @author mreutegg
 */
public class ClearKeywordsReport extends Report {

    /**
     * The relative path to the keyword property.
     */
    private final String keywordRelPath;

    /**
     * Creates a new report.
     *
     * @param dataPath       the path where the content is stored. E.g.
     *                       '/content' or '' (empty String) if the complete
     *                       workspace should be considered.
     * @param keywordRelPath the relative path of the keyword property.
     */
    public ClearKeywordsReport(String dataPath, String keywordRelPath) {
        super(dataPath);
        this.keywordRelPath = keywordRelPath;
    }

    /**
     * {@inheritDoc}
     * <p/>
     * Returns result rows with the following objects:
     * <ul>
     * <li>Path <code>String</code> of the page where the property was removed.</li>
     * </ul>
     */
    public Iterator getResult(Session session) throws RepositoryException {
        KeywordsReport report = new KeywordsReport(getDataPath(), keywordRelPath);
        List modifiedPaths = new ArrayList();
        for (Iterator it = report.getResult(session); it.hasNext(); ) {
            Object[] data = (Object[]) it.next();
            String path = (String) data[0];
            try {
                session.getItem(path + "/" + keywordRelPath).remove();
                modifiedPaths.add(new Object[]{path});
            } catch (PathNotFoundException e) {
                // ignore
            }
        }
        return modifiedPaths.iterator();
    }
}
