// 
// ========================================================================
// Copyright (c) 1995-2021 Mort Bay Consulting Pty Ltd and others.
// ------------------------------------------------------------------------
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// and Apache License v2.0 which accompanies this distribution.
// 
// The Eclipse Public License is available at
// http://www.eclipse.org/legal/epl-v10.html
// 
// The Apache License v2.0 is available at
// http://www.opensource.org/licenses/apache2.0.php
// 
// You may elect to redistribute this code under either of these licenses.
// ========================================================================
// 
package org.eclipse.jetty.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

/**
 *  MemoryUtils provides an abstraction over memory properties and operations.
 *
 * @deprecated The Eclipse Jetty and Apache Felix Http Jetty packages are no longer supported.
 */
@Deprecated(since = "2021-05-27")
public class MemoryUtils {

    private static final int cacheLineBytes;

    static {
        final int defaultValue = 64;
        int value = defaultValue;
        try {
            value = Integer.parseInt(AccessController.doPrivileged(new PrivilegedAction<String>() {

                @Override
                public String run() {
                    return System.getProperty("org.eclipse.jetty.util.cacheLineBytes", String.valueOf(defaultValue));
                }
            }));
        } catch (Exception ignored) {
        }
        cacheLineBytes = value;
    }

    private MemoryUtils() {
    }

    public static int getCacheLineBytes() {
        return cacheLineBytes;
    }

    public static int getIntegersPerCacheLine() {
        return getCacheLineBytes() >> 2;
    }

    public static int getLongsPerCacheLine() {
        return getCacheLineBytes() >> 3;
    }
}
