/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFilterFormatException;
import com.adobe.internal.pdftoolkit.core.filter.CCITTFaxTables;
import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.TableBase;
import java.io.IOException;
import java.io.InputStream;

public class CCITTFaxInputStream
extends DecodeInputStream
implements CCITTFaxTables {
    private static final byte[] decode = new byte[]{117, 116, 29, 30, 45, 46, 22, 22, 23, 23, 47, 48, 13, 13, 13, 13, 20, 20, 33, 34, 35, 36, 37, 38, 19, 19, 31, 32, 1, 1, 1, 1, 12, 12, 12, 12, 53, 54, 26, 26, 39, 40, 41, 42, 43, 44, 21, 21, 28, 28, 61, 62, 63, 0, 68, 69, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11, 27, 27, 59, 60, 114, 115, 18, 18, 24, 24, 49, 50, 51, 52, 25, 25, 55, 56, 57, 58, 66, 66, 66, 66, 89, 89, 89, 89, 70, 71, 108, 73, 72, 109, 110, 111, 112, 113, 67, 67, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 65, 65, 65, 65, 65, 65, 65, 65, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 16, 16, 16, 16, 17, 17, 17, 17, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 14, 14, 14, 14, 15, 15, 15, 15, 64, 64, 64, 64, 64, 64, 64, 64, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 115, 114, 112, 113, 13, 110, 111, 14, 10, 10, 11, 11, 109, 108, 12, 12, 9, 9, 9, 9, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 108, 1, 105, 106, 103, 103, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 108, 109, 107, 107, 108, 95, 95, 101, 101, 96, 96, 96, 96, 100, 100, 100, 100, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 102, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 103, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 97, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98};
    private static final byte[] decode_ext = new byte[]{74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 90, 91, 91, 91, 91, 94, 94, 95, 95, 96, 96, 97, 97, 98, 98, 99, 99, 92, 92, 92, 92, 93, 93, 93, 93, 100, 100, 101, 101, 102, 102, 103, 103, 104, 104, 104, 104, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 105, 106, 20, 20, 20, 20, 34, 34, 35, 35, 36, 36, 37, 37, 38, 38, 39, 39, 21, 21, 21, 21, 42, 42, 43, 43, 0, 0, 0, 0, 0, 0, 0, 0, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 65, 65, 66, 66, 26, 26, 27, 27, 28, 28, 29, 29, 19, 19, 19, 19, 23, 23, 23, 23, 50, 50, 51, 51, 44, 44, 45, 45, 46, 46, 47, 47, 57, 57, 58, 58, 61, 61, 67, 67, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 48, 48, 49, 49, 62, 62, 63, 63, 30, 30, 31, 31, 32, 32, 33, 33, 40, 40, 41, 41, 22, 22, 22, 22, 18, 18, 18, 18, 18, 18, 18, 18, 52, 52, 73, 74, 75, 76, 55, 55, 56, 56, 83, 84, 85, 86, 59, 59, 60, 60, 87, 88, 24, 24, 24, 24, 25, 25, 25, 25, 89, 90, 68, 68, 69, 69, 70, 70, 71, 72, 53, 53, 54, 54, 77, 78, 79, 80, 81, 82, 64, 64, 64, 64, 64, 64, 64, 64, 91, 91, 91, 91, 94, 94, 95, 95, 96, 96, 97, 97, 98, 98, 99, 99, 92, 92, 92, 92, 93, 93, 93, 93, 100, 100, 101, 101, 102, 102, 103, 103, 104, 104, 104, 104, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 105, 106, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 103, 103, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 105, 105, 105, 105, 106, 106, 106, 106, 104, 104, 104, 104, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107, 107};
    private int cols;
    private int rows;
    private int k;
    private int damagedRowsBeforeError;
    private boolean byteAlign;
    private boolean doRTC;
    private boolean doEOL;
    private boolean blackIs1;
    private boolean uncompressedMode;
    private int residue = 0;
    private int residueLen = 0;
    private int curRowNumber = 0;
    private boolean rowIs2D = false;
    private int runs1DIn2D = 0;
    private int appendedInput0s = 0;
    int totalDamagedRows = 0;
    int consecDamagedRows = 0;
    private static final boolean CCITTFaxDebugging = false;
    private int pauseBeyondRow = 0;
    private int stoppedBecause = 0;
    private static final int STILL_RUNNING = 0;
    private static final int CAUSE_INPUT_UNAVAIL = 1;
    private static final int CAUSE_OUTPUT_OVERRUN = 2;
    private static final int CAUSE_UNDEFINED_CODE = 3;
    private static final int CAUSE_ILLEG_CODE = 4;
    private static final int CAUSE_DECODER_BUG = 5;
    private static final int CAUSE_EOL_PREFIX = 6;
    private static final int CAUSE_LINE_DONE = 7;
    private static final int CAUSE_RTC = 8;
    private int curMode = 0;
    private static final int NEXT_W1D = 0;
    private static final int NEXT_B1D = 1;
    private static final int NEXT_WU = 2;
    private static final int NEXT_W2D = 4;
    private static final TableBase[] tBases = new TableBase[]{new TableBase(0, 0, 0), new TableBase(108, 256, 10), new TableBase(216, 512, 20), new TableBase(228, 512, 18), new TableBase(145, 768, 19), new TableBase(145, 768, 19)};
    private byte[] curRow;
    private byte[] prevRow;
    int curRowPos = 0;
    private int a0 = 0;
    private int a0x = 0;
    private int a0xx = 0;
    private int b1 = 0;
    private int db = 0;
    private byte[] outBuf = null;
    private int outCount = 0;
    private int outPos = 0;

    private boolean SufficientResidue(int len) {
        while (this.residueLen < len) {
            int newChar = this.inCount <= this.inPos ? (!this.fillInputBuffer() ? -1 : this.inBuf[this.inPos++] & 0xFF) : this.inBuf[this.inPos++] & 0xFF;
            if (newChar < 0) {
                newChar = 0;
                this.appendedInput0s += 8;
                if (32 < this.appendedInput0s) {
                    this.pendingEOF = true;
                    this.stoppedBecause = 1;
                    return false;
                }
            }
            this.residue = (this.residue << 8) + newChar;
            this.residueLen += 8;
        }
        return true;
    }

    private void SetErrorCause(int cause) {
        this.stoppedBecause = cause;
    }

    private void SwitchCurRowColor() {
        if (this.a0x < this.a0) {
            if (this.a0xx < this.a0x) {
                while (this.a0xx + 128 <= this.a0x) {
                    this.curRow[this.curRowPos] = 127;
                    this.curRow[this.curRowPos + 1] = 0;
                    this.a0xx += 127;
                    this.curRowPos += 2;
                }
                this.curRow[this.curRowPos++] = (byte)(this.a0x - this.a0xx);
                this.a0xx = this.a0x;
            } else if (this.a0xx == 0) {
                this.curRowPos = 2 - (this.curMode & 1);
            }
            this.a0x = this.a0;
        } else {
            this.a0x = this.a0xx;
        }
        this.curMode ^= 1;
    }

    private void SwitchPrevRowColor(boolean rightward) {
        if (!rightward && 0 < this.b1) {
            this.b1 -= this.prevRow[--this.db];
            while (this.prevRow[this.db - 1] == 0 && 0 < this.b1) {
                this.db -= 2;
                this.b1 -= this.prevRow[this.db];
            }
        } else if (this.b1 < this.cols) {
            this.b1 += this.prevRow[this.db++];
            while (this.prevRow[this.db] == 0 && this.b1 < this.cols) {
                this.b1 += this.prevRow[this.db + 1];
                this.db += 2;
            }
        } else {
            this.db += this.prevRow[this.db - 1] == 0 ? -1 : 1;
        }
    }

    private void SynchPrevRowColor() {
        if ((this.db ^ this.curMode) == 0) {
            this.SwitchPrevRowColor(true);
        }
    }

    private boolean LineContinues(boolean switchColor) {
        boolean result = true;
        if (this.cols <= this.a0) {
            if (this.cols < this.a0) {
                this.SetErrorCause(2);
                this.a0 = this.cols;
                result = false;
            } else if (switchColor && !this.doEOL && this.runs1DIn2D < 1) {
                this.stoppedBecause = 7;
                result = false;
            }
        }
        if (switchColor) {
            this.SwitchCurRowColor();
        }
        return result;
    }

    private boolean UncompressedEscape(int color) {
        if (!this.uncompressedMode || 0 < this.runs1DIn2D) {
            this.SetErrorCause(4);
            return false;
        }
        if (!this.LineContinues((this.curMode & 1) != color)) {
            return false;
        }
        this.curMode = (this.curMode >>> 1 != 1 ? 2 : (this.rowIs2D ? 4 : 0)) + color;
        if (4 <= this.curMode) {
            this.SynchPrevRowColor();
        }
        return true;
    }

    private void InitRow() {
        this.curRow[0] = 0;
        this.curRow[1] = 0;
        this.a0xx = 0;
        this.a0x = 0;
        this.a0 = 0;
    }

    private void FinishRow() {
        this.a0 = this.cols;
        this.SwitchCurRowColor();
        while (this.a0xx < this.cols) {
            if (this.a0 == this.a0x) {
                ++this.a0;
            }
            this.SwitchCurRowColor();
        }
        this.curRow[this.curRowPos++] = 0;
        this.curRow[this.curRowPos++] = 0;
    }

    private void MakeRowWhite() {
        this.InitRow();
        this.curMode = 0;
        this.FinishRow();
    }

    private void ExchangeRowPair() {
        byte[] tempLine = this.curRow;
        this.curRow = this.prevRow;
        this.prevRow = tempLine;
    }

    public CCITTFaxInputStream(InputStream in, int inSize, int outSize, FilterParams params) {
        super(in, inSize, outSize, 0, params);
        this.initFax();
    }

    public CCITTFaxInputStream(InputStream in, FilterParams params) {
        this(in, 2048, 0, params);
    }

    public CCITTFaxInputStream(InputStream in) {
        this(in, null);
    }

    private void initFax() {
        int w;
        int width = 0;
        if (this.diparams.containsKey("Width")) {
            width = (Integer)this.diparams.get("Width");
        }
        this.cols = 0;
        if (this.diparams.containsKey("Columns")) {
            this.cols = (Integer)this.diparams.get("Columns");
        }
        this.rows = 0;
        if (this.diparams.containsKey("Rows")) {
            this.rows = (Integer)this.diparams.get("Rows");
        } else if (this.diparams.containsKey("Height")) {
            this.rows = (Integer)this.diparams.get("Height");
        }
        this.k = 0;
        if (this.diparams.containsKey("K")) {
            this.k = (Integer)this.diparams.get("K");
        }
        this.damagedRowsBeforeError = 0;
        if (this.diparams.containsKey("DamagedRowsBeforeError")) {
            this.damagedRowsBeforeError = (Integer)this.diparams.get("DamagedRowsBeforeError");
        }
        this.byteAlign = false;
        if (this.diparams.containsKey("ByteAlign")) {
            this.byteAlign = (Boolean)this.diparams.get("ByteAlign");
        }
        this.doRTC = true;
        if (this.diparams.containsKey("DoRTC")) {
            this.doRTC = (Boolean)this.diparams.get("DoRTC");
        }
        this.doEOL = false;
        if (this.diparams.containsKey("DoEOL")) {
            this.doEOL = (Boolean)this.diparams.get("DoEOL");
        }
        this.blackIs1 = false;
        if (this.diparams.containsKey("BlackIs1")) {
            this.blackIs1 = (Boolean)this.diparams.get("BlackIs1");
        }
        this.uncompressedMode = false;
        if (this.diparams.containsKey("UncompressedMode")) {
            this.uncompressedMode = (Boolean)this.diparams.get("UncompressedMode");
        }
        if (this.cols < 1) {
            this.cols = 1728;
        }
        if (this.cols < width) {
            this.cols = width;
        }
        if (((DecodeInputStream)this).outBuf.length < (w = (this.cols + 7) / 8)) {
            ((DecodeInputStream)this).outBuf = new byte[w + 1];
        }
        this.curRow = new byte[this.cols + 5];
        this.prevRow = new byte[this.cols + 5];
        this.MakeRowWhite();
    }

    @Override
    public void close() throws IOException {
        this.curRow = null;
        this.prevRow = null;
        super.close();
    }

    @Override
    public void fill() {
        block61: {
            block64: {
                int consecEOLs;
                block62: {
                    block63: {
                        boolean eolRequiredPreambleOK;
                        if (this.outBuf == null) {
                            this.outBuf = this.markPos < 0 ? ((DecodeInputStream)this).outBuf : new byte[((DecodeInputStream)this).outBuf.length];
                        }
                        this.stoppedBecause = 0;
                        consecEOLs = 0;
                        int leading0s = 0;
                        this.rowIs2D = this.k < 0;
                        this.stoppedBecause = 0;
                        int pickyEOLErrors = 0;
                        boolean bl = eolRequiredPreambleOK = 0 < this.consecDamagedRows;
                        while (this.residueLen >= 1 || this.SufficientResidue(1)) {
                            if ((this.residue & -1 >>> 32 - this.residueLen) == 0) {
                                leading0s += this.residueLen;
                                this.residueLen = 0;
                                continue;
                            }
                            while ((this.residue >>> this.residueLen - 1 & 1) == 0) {
                                ++leading0s;
                                --this.residueLen;
                            }
                            if (leading0s < 11) {
                                if (eolRequiredPreambleOK) {
                                    leading0s = 0;
                                    --this.residueLen;
                                    continue;
                                }
                                this.residueLen += leading0s;
                                break;
                            }
                            eolRequiredPreambleOK = false;
                            --this.residueLen;
                            if (0 < this.k) {
                                if (this.residueLen < 1 && !this.SufficientResidue(1)) break block61;
                                if ((this.residue >>> this.residueLen - 1 & 1) == 0) {
                                    this.rowIs2D = true;
                                }
                                --this.residueLen;
                            }
                            if (2 <= ++consecEOLs) {
                                if (11 < leading0s || 0 < this.k && this.rowIs2D) {
                                    ++pickyEOLErrors;
                                }
                                if (this.k < 0 || 6 <= consecEOLs) {
                                    this.stoppedBecause = 8;
                                    break block61;
                                }
                            }
                            leading0s = 0;
                        }
                        if (!this.doEOL) break block62;
                        if (0 > this.k || 0 >= this.damagedRowsBeforeError || 3 > consecEOLs || pickyEOLErrors != 0) break block63;
                        this.stoppedBecause = 8;
                        break block61;
                    }
                    if (consecEOLs == true) break block62;
                    this.SetErrorCause(4);
                    break block61;
                }
                if (consecEOLs != 0 || 0 >= this.k) break block64;
                if (this.residueLen < 1 && !this.SufficientResidue(1)) break block61;
                if ((this.residue >>> this.residueLen - 1 & 1) == 0) {
                    this.rowIs2D = true;
                }
                --this.residueLen;
            }
            this.ExchangeRowPair();
            this.InitRow();
            this.db = 1;
            this.b1 = 0;
            this.curMode = this.rowIs2D ? 4 : 0;
            this.runs1DIn2D = 0;
            block11: while (this.residueLen >= 8 || this.SufficientResidue(8)) {
                int inputChunk = this.residue >>> this.residueLen - 8 & 0xFF;
                int decodeIndex = CCITTFaxInputStream.tBases[this.curMode].decode + inputChunk;
                byte code = decode[decodeIndex];
                if (code < 64 && this.a0 + code < this.cols) {
                    int priorRunLen;
                    this.residueLen -= encode[CCITTFaxInputStream.tBases[this.curMode].encode + code] & 0xF;
                    this.a0 += code;
                    if (0 < this.runs1DIn2D && --this.runs1DIn2D == 0) {
                        this.curMode ^= 4;
                    }
                    if (this.a0x < this.a0 && 0 < (priorRunLen = this.a0x - this.a0xx) && priorRunLen < 127) {
                        this.curRow[this.curRowPos++] = (byte)priorRunLen;
                        this.curMode ^= 1;
                        this.a0xx = this.a0x;
                        this.a0x = this.a0;
                        continue;
                    }
                    this.SwitchCurRowColor();
                    continue;
                }
                if (108 <= code) {
                    if (this.residueLen < 13 && !this.SufficientResidue(13)) break;
                    inputChunk = this.residue >>> this.residueLen - 13 & 0x1F;
                    decodeIndex = (CCITTFaxInputStream.tBases[this.curMode].decodeExt + (code - 108) << 5) + inputChunk;
                    code = decode_ext[decodeIndex];
                }
                this.residueLen -= encode[CCITTFaxInputStream.tBases[this.curMode].encode + code] & 0xF;
                if (4 <= this.curMode) {
                    while (this.b1 < this.a0 || this.b1 < this.cols && (this.prevRow[this.db] == 0 || (this.b1 == 0 ? (this.curMode & 1) != 0 : this.b1 == this.a0 || this.prevRow[this.db - 1] == 0))) {
                        this.b1 += this.prevRow[this.db] + this.prevRow[this.db + 1];
                        this.db += 2;
                    }
                    if (code <= 101) {
                        this.a0 = this.b1 + (code - 98);
                        if (this.a0 < this.a0x) {
                            this.SetErrorCause(4);
                            break;
                        }
                        if (!this.LineContinues(true)) break;
                        this.SwitchPrevRowColor(96 < code);
                        continue;
                    }
                    if (code == 102) {
                        this.SwitchPrevRowColor(true);
                        this.a0 = this.b1;
                        this.SwitchPrevRowColor(true);
                        if (this.LineContinues(false)) continue;
                        break;
                    }
                    if (code == 103) {
                        this.curMode ^= 4;
                        this.runs1DIn2D = 2;
                        continue;
                    }
                } else if (code < 104) {
                    boolean termRun;
                    boolean bl = termRun = code < 64;
                    if (termRun) {
                        this.a0 += code;
                        if (0 < this.runs1DIn2D && --this.runs1DIn2D == 0) {
                            this.curMode ^= 4;
                        }
                    } else {
                        this.a0 = this.curMode <= 1 ? (this.a0 += 64 * (code - 63)) : (this.curMode == 2 ? (this.a0 += 5) : (this.a0 += 11));
                    }
                    if (this.LineContinues(termRun)) continue;
                    break;
                }
                switch (code) {
                    case 104: {
                        this.residueLen += 11;
                        if (this.a0 != this.cols) {
                            this.SetErrorCause(4);
                        } else {
                            this.stoppedBecause = 6;
                        }
                        this.LineContinues(true);
                        break;
                    }
                    case 105: {
                        if (this.UncompressedEscape(0)) continue block11;
                        break;
                    }
                    case 106: {
                        if (this.UncompressedEscape(1)) continue block11;
                        break;
                    }
                    default: {
                        this.SetErrorCause(3);
                        break;
                    }
                }
                break;
            }
        }
        if (7 <= this.stoppedBecause && this.byteAlign) {
            this.residueLen &= 0xFFFFFFF8;
        }
        switch (this.stoppedBecause) {
            case 8: {
                this.pendingEOF = true;
            }
            case 1: {
                return;
            }
        }
        if (++this.curRowNumber == this.rows && !this.doRTC) {
            this.pendingEOF = true;
        }
        if (!(6 > this.stoppedBecause || this.rowIs2D && this.consecDamagedRows != 0)) {
            this.consecDamagedRows = 0;
            this.FinishRow();
        } else {
            if (this.damagedRowsBeforeError <= this.totalDamagedRows++ || this.k < 0) {
                this.pendingException = new PDFFilterFormatException("CCITTFaxDecode: Too many damaged rows");
                return;
            }
            if (this.consecDamagedRows++ < 1) {
                this.ExchangeRowPair();
            } else {
                this.MakeRowWhite();
            }
        }
        int outBitPos = this.outPos << 3;
        int outBitPosLim = outBitPos + this.cols;
        int n = this.curRowPos = this.blackIs1 ? 1 : 0;
        while (outBitPos < outBitPosLim) {
            int runByteLen;
            int outBytePos;
            int runLen = this.curRow[this.curRowPos];
            int bitsUsedInOutByte = outBitPos & 7;
            if (bitsUsedInOutByte != 0) {
                int n2 = outBitPos >>> 3;
                this.outBuf[n2] = (byte)(this.outBuf[n2] | 255 >>> bitsUsedInOutByte);
                outBitPos += 8 - bitsUsedInOutByte;
                runLen -= 8 - bitsUsedInOutByte;
            }
            if (0 < runLen) {
                outBytePos = outBitPos >>> 3;
                runByteLen = runLen + 7 >>> 3;
                outBitPos += runByteLen << 3;
                runLen -= runByteLen << 3;
                while (0 < runByteLen) {
                    this.outBuf[outBytePos++] = -1;
                    --runByteLen;
                }
            }
            outBitPos += runLen;
            runLen = this.curRow[this.curRowPos + 1];
            bitsUsedInOutByte = outBitPos & 7;
            if (bitsUsedInOutByte != 0) {
                int n3 = outBitPos >>> 3;
                this.outBuf[n3] = (byte)(this.outBuf[n3] & ~(255 >>> bitsUsedInOutByte));
                outBitPos += 8 - bitsUsedInOutByte;
                runLen -= 8 - bitsUsedInOutByte;
            }
            if (0 < runLen) {
                outBytePos = outBitPos >>> 3;
                runByteLen = runLen + 7 >>> 3;
                outBitPos += runByteLen << 3;
                runLen -= runByteLen << 3;
                while (0 < runByteLen) {
                    this.outBuf[outBytePos++] = 0;
                    --runByteLen;
                }
            }
            outBitPos += runLen;
            this.curRowPos += 2;
        }
        int bitsUsedInOutByte = outBitPos & 7;
        if (bitsUsedInOutByte != 0) {
            int n4 = outBitPos >>> 3;
            this.outBuf[n4] = (byte)(this.outBuf[n4] & ~(255 >>> bitsUsedInOutByte));
            outBitPos += 8 - bitsUsedInOutByte;
        }
        this.outCount = outBitPos >>> 3;
        this.outPos = 0;
        if (this.markPos < 0) {
            ((DecodeInputStream)this).outPos = this.outPos;
            ((DecodeInputStream)this).outCount = this.outCount;
        } else {
            ((DecodeInputStream)this).outCount += this.outCount;
            if (((DecodeInputStream)this).outBuf.length < ((DecodeInputStream)this).outPos + this.outCount) {
                byte[] newOutBuf = new byte[((DecodeInputStream)this).outPos + this.outCount];
                System.arraycopy(((DecodeInputStream)this).outBuf, 0, newOutBuf, 0, ((DecodeInputStream)this).outPos);
                ((DecodeInputStream)this).outBuf = newOutBuf;
            }
            System.arraycopy(this.outBuf, 0, ((DecodeInputStream)this).outBuf, ((DecodeInputStream)this).outPos, this.outCount);
        }
    }

    @Override
    protected boolean increaseBufferSize(long markLimitPlusHeadroom) {
        return false;
    }
}

