/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import com.day.image.AbstractBufferedImageOp;
import com.day.image.ImageSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class DitherOp
extends AbstractBufferedImageOp {
    public static final DitherAlgorithm DITHER_NONE = new DitherSimple();
    public static final DitherAlgorithm DITHER_SIMPLE_ERROR_CORRECTION = new DitherErrorCorrection();
    private final int nCol;
    private final Color transparency;
    private final Color bgcolor;
    private final DitherAlgorithm algorithm;

    public DitherOp(int nCol, Color transparency, Color bgcolor, DitherAlgorithm algorithm, RenderingHints hints) {
        super(hints);
        if (algorithm == null) {
            throw new NullPointerException("algorithm");
        }
        if (nCol < 2) {
            throw new IllegalArgumentException("nCol < 2");
        }
        this.nCol = nCol;
        this.transparency = transparency;
        this.bgcolor = bgcolor;
        this.algorithm = algorithm;
    }

    public static BufferedImage convertToIndexed(BufferedImage src, int nCol, Color transparency, Color bgcolor, RenderingHints hints) {
        if (src == null) {
            throw new NullPointerException("src image is null");
        }
        ColorModel srcCM = src.getColorModel();
        if (srcCM instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcCM;
            if (icm.getMapSize() <= nCol) {
                return src;
            }
            src = icm.convertToIntDiscrete(src.getRaster(), true);
        }
        src = ImageSupport.coerceData(src, true);
        boolean doTransparency = transparency != null && nCol > 2;
        int transpOffset = doTransparency ? 1 : 0;
        DitherOp dither = new DitherOp(nCol - transpOffset, transparency, bgcolor, DITHER_NONE, hints);
        WritableRaster srcRas = src.getRaster();
        dither.prepareSourceImage(src);
        OctTree tree = dither.buildColorTree(srcRas);
        int w = src.getWidth();
        int h = src.getHeight();
        dither.indexColorTree(tree, false);
        int size = tree.leafCount + transpOffset;
        byte[] cmap = tree.createColorMap(new byte[size * 3]);
        int bits = 0;
        int ts = size;
        while (ts > 0) {
            ts >>= 1;
            ++bits;
        }
        int transparentIndex = size - 1;
        if (doTransparency) {
            OctTreeNode node = tree.getNode(transparency.getRed(), transparency.getGreen(), transparency.getBlue());
            node.nofcolors = transparentIndex;
        }
        IndexColorModel cm = new IndexColorModel(bits, size, cmap, 0, false, transparentIndex);
        WritableRaster dstRas = cm.createCompatibleWritableRaster(w, h);
        BufferedImage dst = new BufferedImage(cm, dstRas, cm.isAlphaPremultiplied(), null);
        int bands = srcRas.getNumBands();
        int[] srcChunk = new int[bands * w];
        int[] dstChunk = new int[w];
        for (int y = 0; y < h; ++y) {
            srcRas.getPixels(0, y, w, 1, srcChunk);
            int x = srcChunk.length - bands;
            int i = dstChunk.length - 1;
            while (x >= 0) {
                if (srcChunk[x + 3] == 0 && doTransparency) {
                    dstChunk[i] = transparentIndex;
                } else {
                    OctTreeNode node = tree.getNode(srcChunk[x], srcChunk[x + 1], srcChunk[x + 2]);
                    dstChunk[i] = node.nofcolors;
                }
                x -= bands;
                --i;
            }
            dstRas.setPixels(0, y, w, 1, dstChunk);
        }
        return dst;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        src = ImageSupport.coerceData(src, true);
        return super.filter(src, dst);
    }

    protected void doFilter(BufferedImage srcIm, BufferedImage dstIm) {
        WritableRaster srcRas = srcIm.getRaster();
        WritableRaster dstRas = dstIm.getRaster();
        this.prepareSourceImage(srcIm);
        OctTree tree = this.buildColorTree(srcRas);
        if (!tree.isReduced()) {
            dstIm.getGraphics().drawImage(srcIm, 0, 0, null);
        }
        this.indexColorTree(tree, false);
        this.algorithm.dither(srcRas, dstRas, tree);
    }

    private void prepareSourceImage(BufferedImage srcIm) {
        if (this.bgcolor != null) {
            Graphics2D g2 = srcIm.createGraphics();
            g2.setComposite(AlphaComposite.DstOver);
            Color col = this.bgcolor.getAlpha() != 0 ? new Color(this.bgcolor.getRGB() & 0xFFFFFF, true) : this.bgcolor;
            g2.setColor(col);
            g2.fillRect(0, 0, srcIm.getWidth(), srcIm.getHeight());
            g2.dispose();
        }
    }

    private OctTree buildColorTree(Raster srcRas) {
        int w = srcRas.getWidth();
        int h = srcRas.getHeight();
        int size = w * h;
        int bands = srcRas.getNumBands();
        int[] chunk = new int[bands * w];
        OctTree tree = new OctTree();
        for (int y = 0; y < h; ++y) {
            srcRas.getPixels(0, y, w, 1, chunk);
            for (int x = chunk.length - bands; x >= 0; x -= bands) {
                tree.insertNode(chunk[x], chunk[x + 1], chunk[x + 2], 1);
            }
            while (tree.leafCount > this.nCol) {
                tree.reduceNode();
            }
        }
        if (this.transparency != null) {
            tree.insertNode(this.transparency.getRed(), this.transparency.getGreen(), this.transparency.getBlue(), size);
        }
        if (this.bgcolor != null && !this.bgcolor.equals(this.transparency)) {
            tree.insertNode(this.bgcolor.getRed(), this.bgcolor.getGreen(), this.bgcolor.getBlue(), size);
        }
        while (tree.leafCount > this.nCol) {
            tree.reduceNode();
        }
        return tree;
    }

    private byte[] indexColorTree(OctTree tree, boolean createCMap) {
        tree.indexTree();
        if (this.transparency != null) {
            tree.getNode((int)this.transparency.getRed(), (int)this.transparency.getGreen(), (int)this.transparency.getBlue()).a = 0;
        }
        return createCMap ? tree.createColorMap(null) : null;
    }

    private static class OctTree {
        private static final int MAX_DEPTH = 8;
        private int leafCount;
        private final OctTreeNode root = new OctTreeNode(null);
        private final OctTreeNode[] redtable = new OctTreeNode[9];
        private final int[] rednof = new int[9];
        private int reddepth;

        public OctTree() {
            for (int i = 0; i < this.redtable.length; ++i) {
                this.redtable[i] = new OctTreeNode(null);
            }
        }

        public void indexTree() {
            this.root.indexTree();
        }

        public OctTreeNode getNode(int r, int g, int b) {
            OctTreeNode node = this.root;
            int m = 256;
            while (node != null) {
                if (node.leaf) {
                    return node;
                }
                int c = 0;
                if ((r & (m >>= 1)) != 0) {
                    c = (short)(c | 4);
                }
                if ((g & m) != 0) {
                    c = (short)(c | 2);
                }
                if ((b & m) != 0) {
                    c = (short)(c + 1);
                }
                node = node.childs[c];
            }
            return null;
        }

        public void insertNode(int r, int g, int b, int count) {
            OctTreeNode node = this.root;
            int m = 256;
            while (node != null) {
                if (node.leaf) {
                    node.nofcolors += count;
                    node.sr += r * count;
                    node.sg += g * count;
                    node.sb += b * count;
                    break;
                }
                int c = 0;
                if ((r & (m >>= 1)) != 0) {
                    c |= 4;
                }
                if ((g & m) != 0) {
                    c |= 2;
                }
                if ((b & m) != 0) {
                    c |= 1;
                }
                if (node.childs[c] == null) {
                    node = node.childs[c] = new OctTreeNode(node);
                    if (m != 1) continue;
                    node.leaf = true;
                    ++this.leafCount;
                    this.insertNode(this.redtable[8], node);
                    this.rednof[8] = this.rednof[8] + 1;
                    this.reddepth = 8;
                    continue;
                }
                node = node.childs[c];
            }
        }

        public boolean isReduced() {
            for (int i = 7; i >= 0; --i) {
                if (this.rednof[i] == 0) continue;
                return true;
            }
            return false;
        }

        public void reduceNode() {
            OctTreeNode node = this.getReducibleNode();
            int sr = 0;
            int sg = 0;
            int sb = 0;
            int cc = 0;
            int c = 0;
            for (int i = 0; i < 8; ++i) {
                OctTreeNode child = node.childs[i];
                if (child == null) continue;
                ++c;
                sr += child.sr;
                sg += child.sg;
                sb += child.sb;
                cc += child.nofcolors;
                this.deleteNode(this.redtable[child.depth], child);
                int n = child.depth;
                this.rednof[n] = this.rednof[n] - 1;
                node.childs[i] = null;
            }
            node.leaf = true;
            node.nofcolors = cc;
            node.sr = sr;
            node.sg = sg;
            node.sb = sb;
            int d = node.depth;
            this.insertNode(this.redtable[d], node);
            int n = d;
            this.rednof[n] = this.rednof[n] + 1;
            if (this.rednof[d + 1] == 0) {
                --this.reddepth;
            }
            this.leafCount -= c - 1;
        }

        public byte[] createColorMap(byte[] cmap) {
            int mapSize = this.leafCount * 3;
            if (cmap == null || cmap.length < mapSize) {
                cmap = new byte[mapSize];
            }
            int j = 0;
            for (int i = this.redtable.length - 1; i >= 0; --i) {
                OctTreeNode n = this.redtable[i].next;
                while (n != null) {
                    n.nofcolors = j / 3;
                    cmap[j++] = (byte)(n.r & 0xFF);
                    cmap[j++] = (byte)(n.g & 0xFF);
                    cmap[j++] = (byte)(n.b & 0xFF);
                    n = n.next;
                }
            }
            return cmap;
        }

        private void deleteNode(OctTreeNode root, OctTreeNode node) {
            OctTreeNode p = root;
            OctTreeNode q = root.next;
            while (q != null && q != node) {
                p = q;
                q = q.next;
            }
            if (q == node) {
                p.next = node.next;
                node.next = null;
            }
        }

        private void insertNode(OctTreeNode root, OctTreeNode node) {
            OctTreeNode p = root;
            OctTreeNode q = p.next;
            while (q != null) {
                p = q;
                q = q.next;
            }
            p.next = node;
            node.next = null;
        }

        private OctTreeNode getReducibleNode() {
            int m = Integer.MAX_VALUE;
            OctTreeNode n = this.redtable[this.reddepth].next;
            OctTreeNode bn = null;
            while (n != null) {
                if (n.nofcolors < m) {
                    m = n.nofcolors;
                    bn = n;
                }
                n = n.next;
            }
            return bn != null ? bn.parent : null;
        }
    }

    private static final class OctTreeNode {
        public int sr;
        public int sg;
        public int sb;
        public int r;
        public int g;
        public int b;
        public int a = 255;
        public OctTreeNode[] childs = new OctTreeNode[8];
        public OctTreeNode parent;
        public boolean leaf;
        public int nofcolors;
        public int depth;
        public OctTreeNode next;

        private OctTreeNode(OctTreeNode parent) {
            this.depth = parent != null ? parent.depth + 1 : 0;
            this.parent = parent;
            this.leaf = false;
            this.next = null;
        }

        public void indexTree() {
            if (this.leaf) {
                int roundoff = this.nofcolors >> 1;
                this.r = (this.sr + roundoff) / this.nofcolors;
                this.g = (this.sg + roundoff) / this.nofcolors;
                this.b = (this.sb + roundoff) / this.nofcolors;
            } else {
                for (int i = 0; i < 8; ++i) {
                    if (this.childs[i] == null) continue;
                    this.childs[i].indexTree();
                }
            }
        }
    }

    private static class DitherErrorCorrection
    implements DitherAlgorithm {
        private DitherErrorCorrection() {
        }

        public void dither(Raster src, WritableRaster dst, OctTree tree) {
        }
    }

    private static class DitherSimple
    implements DitherAlgorithm {
        private DitherSimple() {
        }

        public void dither(Raster src, WritableRaster dst, OctTree tree) {
            int w = src.getWidth();
            int h = src.getHeight();
            int bands = src.getNumBands();
            int[] chunk = new int[bands * w];
            for (int y = 0; y < h; ++y) {
                src.getPixels(0, y, w, 1, chunk);
                for (int x = chunk.length - bands; x >= 0; x -= bands) {
                    OctTreeNode node = tree.getNode(chunk[x], chunk[x + 1], chunk[x + 2]);
                    chunk[x] = node.r;
                    chunk[x + 1] = node.g;
                    chunk[x + 2] = node.b;
                    chunk[x + 3] = node.a;
                }
                dst.setPixels(0, y, w, 1, chunk);
            }
        }
    }

    public static interface DitherAlgorithm {
        public void dither(Raster var1, WritableRaster var2, OctTree var3);
    }
}

