/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external.basic;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.commons.DebugTimer;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalGroup;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentity;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalIdentityRef;
import org.apache.jackrabbit.oak.spi.security.authentication.external.ExternalUser;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncContext;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncException;
import org.apache.jackrabbit.oak.spi.security.authentication.external.SyncResult;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncConfig;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncResultImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.external.basic.DefaultSyncedIdentity;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSyncContext
implements SyncContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultSyncContext.class);
    public static final String REP_EXTERNAL_ID = "rep:externalId";
    public static final String REP_LAST_SYNCED = "rep:lastSynced";
    protected final DefaultSyncConfig config;
    protected final ExternalIdentityProvider idp;
    protected final UserManager userManager;
    protected final ValueFactory valueFactory;
    protected boolean keepMissing;
    protected boolean forceUserSync;
    protected boolean forceGroupSync;
    protected final long now;
    protected final Value nowValue;

    public DefaultSyncContext(@NotNull DefaultSyncConfig config, @NotNull ExternalIdentityProvider idp, @NotNull UserManager userManager, @NotNull ValueFactory valueFactory) {
        this.config = config;
        this.idp = idp;
        this.userManager = userManager;
        this.valueFactory = valueFactory;
        Calendar nowCal = Calendar.getInstance();
        this.nowValue = valueFactory.createValue(nowCal);
        this.now = nowCal.getTimeInMillis();
    }

    @Nullable
    public static DefaultSyncedIdentity createSyncedIdentity(@Nullable Authorizable auth) throws RepositoryException {
        if (auth == null) {
            return null;
        }
        ExternalIdentityRef ref = DefaultSyncContext.getIdentityRef(auth);
        Value[] lmValues = auth.getProperty(REP_LAST_SYNCED);
        long lastModified = -1L;
        if (lmValues != null && lmValues.length > 0) {
            lastModified = lmValues[0].getLong();
        }
        return new DefaultSyncedIdentity(auth.getID(), ref, auth.isGroup(), lastModified);
    }

    @Nullable
    public static ExternalIdentityRef getIdentityRef(@Nullable Authorizable auth) throws RepositoryException {
        if (auth == null) {
            return null;
        }
        Value[] v = auth.getProperty(REP_EXTERNAL_ID);
        if (v == null || v.length == 0) {
            return null;
        }
        return ExternalIdentityRef.fromString(v[0].getString());
    }

    @Deprecated
    public static String joinPaths(String ... paths) {
        return PathUtils.concatRelativePaths(paths);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isKeepMissing() {
        return this.keepMissing;
    }

    @Override
    @NotNull
    public SyncContext setKeepMissing(boolean keepMissing) {
        this.keepMissing = keepMissing;
        return this;
    }

    @Override
    public boolean isForceUserSync() {
        return this.forceUserSync;
    }

    @Override
    @NotNull
    public SyncContext setForceUserSync(boolean forceUserSync) {
        this.forceUserSync = forceUserSync;
        return this;
    }

    @Override
    public boolean isForceGroupSync() {
        return this.forceGroupSync;
    }

    @Override
    @NotNull
    public SyncContext setForceGroupSync(boolean forceGroupSync) {
        this.forceGroupSync = forceGroupSync;
        return this;
    }

    @Override
    @NotNull
    public SyncResult sync(@NotNull ExternalIdentity identity) throws SyncException {
        ExternalIdentityRef ref = identity.getExternalId();
        if (!this.isSameIDP(ref)) {
            boolean isGroup = identity instanceof ExternalGroup;
            return new DefaultSyncResultImpl(new DefaultSyncedIdentity(identity.getId(), ref, isGroup, -1L), SyncResult.Status.FOREIGN);
        }
        try {
            DefaultSyncResultImpl ret;
            DebugTimer timer = new DebugTimer();
            boolean created = false;
            if (identity instanceof ExternalUser) {
                User user = this.getAuthorizable(identity, User.class);
                timer.mark("find");
                if (user == null) {
                    user = this.createUser((ExternalUser)identity);
                    timer.mark("create");
                    created = true;
                }
                ret = this.syncUser((ExternalUser)identity, user);
                timer.mark("sync");
            } else if (identity instanceof ExternalGroup) {
                Group group = this.getAuthorizable(identity, Group.class);
                timer.mark("find");
                if (group == null) {
                    group = this.createGroup((ExternalGroup)identity);
                    timer.mark("create");
                    created = true;
                }
                ret = this.syncGroup((ExternalGroup)identity, group);
                timer.mark("sync");
            } else {
                throw new IllegalArgumentException("identity must be user or group but was: " + identity);
            }
            log.debug("sync({}) -> {} {}", ref.getString(), identity.getId(), timer);
            if (created) {
                ret.setStatus(SyncResult.Status.ADD);
            }
            return ret;
        }
        catch (RepositoryException e) {
            throw new SyncException(e);
        }
    }

    @Override
    @NotNull
    public SyncResult sync(@NotNull String id) throws SyncException {
        try {
            DefaultSyncResultImpl ret;
            DebugTimer timer = new DebugTimer();
            Authorizable auth = this.userManager.getAuthorizable(id);
            if (auth == null) {
                return new DefaultSyncResultImpl(new DefaultSyncedIdentity(id, null, false, -1L), SyncResult.Status.NO_SUCH_AUTHORIZABLE);
            }
            ExternalIdentityRef ref = DefaultSyncContext.getIdentityRef(auth);
            if (ref == null || !this.isSameIDP(ref)) {
                return new DefaultSyncResultImpl(new DefaultSyncedIdentity(id, ref, auth.isGroup(), -1L), SyncResult.Status.FOREIGN);
            }
            if (auth.isGroup()) {
                ExternalGroup external = this.idp.getGroup(id);
                timer.mark("retrieve");
                if (external == null) {
                    ret = this.handleMissingIdentity(id, auth, timer);
                } else {
                    ret = this.syncGroup(external, (Group)auth);
                    timer.mark("sync");
                }
            } else {
                ExternalUser external = this.idp.getUser(id);
                timer.mark("retrieve");
                if (external == null) {
                    ret = this.handleMissingIdentity(id, auth, timer);
                } else {
                    ret = this.syncUser(external, (User)auth);
                    timer.mark("sync");
                }
            }
            log.debug("sync({}) -> {} {}", id, ref.getString(), timer);
            return ret;
        }
        catch (RepositoryException | ExternalIdentityException e) {
            throw new SyncException(e);
        }
    }

    private DefaultSyncResultImpl handleMissingIdentity(@NotNull String id, @NotNull Authorizable authorizable, @NotNull DebugTimer timer) throws RepositoryException {
        SyncResult.Status status;
        DefaultSyncedIdentity syncId = DefaultSyncContext.createSyncedIdentity(authorizable);
        if (authorizable.isGroup() && ((Group)authorizable).getDeclaredMembers().hasNext()) {
            log.info("won't remove local group with members: {}", (Object)id);
            status = SyncResult.Status.NOP;
        } else if (!this.keepMissing) {
            if (this.config.user().getDisableMissing() && !authorizable.isGroup()) {
                ((User)authorizable).disable("No longer exists on external identity provider '" + this.idp.getName() + "'");
                log.debug("disabling user '{}' that no longer exists on IDP {}", (Object)id, (Object)this.idp.getName());
                status = SyncResult.Status.DISABLE;
            } else {
                authorizable.remove();
                log.debug("removing authorizable '{}' that no longer exists on IDP {}", (Object)id, (Object)this.idp.getName());
                status = SyncResult.Status.DELETE;
            }
            timer.mark("remove");
        } else {
            status = SyncResult.Status.MISSING;
            log.info("external identity missing for {}, but purge == false.", (Object)id);
        }
        return new DefaultSyncResultImpl(syncId, status);
    }

    @Nullable
    protected <T extends Authorizable> T getAuthorizable(@NotNull ExternalIdentity external, @NotNull Class<T> type) throws RepositoryException, SyncException {
        Authorizable authorizable = this.userManager.getAuthorizable(external.getId());
        if (authorizable == null) {
            authorizable = this.userManager.getAuthorizable(external.getPrincipalName());
        }
        if (authorizable == null) {
            return null;
        }
        if (type.isInstance(authorizable)) {
            return (T)authorizable;
        }
        log.error("Unable to process external {}: {}. Colliding authorizable exists in repository.", (Object)type.getSimpleName(), (Object)external.getId());
        throw new SyncException("Unexpected authorizable: " + authorizable);
    }

    @NotNull
    protected User createUser(@NotNull ExternalUser externalUser) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(externalUser.getPrincipalName());
        String authId = this.config.user().isApplyRFC7613UsernameCaseMapped() ? Normalizer.normalize(externalUser.getId().toLowerCase(), Normalizer.Form.NFKC) : externalUser.getId();
        User user = this.userManager.createUser(authId, null, principal, PathUtils.concatRelativePaths(this.config.user().getPathPrefix(), externalUser.getIntermediatePath()));
        this.setExternalId(user, externalUser);
        return user;
    }

    @NotNull
    protected Group createGroup(@NotNull ExternalGroup externalGroup) throws RepositoryException {
        PrincipalImpl principal = new PrincipalImpl(externalGroup.getPrincipalName());
        Group group = this.userManager.createGroup(externalGroup.getId(), principal, PathUtils.concatRelativePaths(this.config.group().getPathPrefix(), externalGroup.getIntermediatePath()));
        this.setExternalId(group, externalGroup);
        return group;
    }

    private void setExternalId(@NotNull Authorizable authorizable, @NotNull ExternalIdentity externalIdentity) throws RepositoryException {
        log.debug("Fallback: setting rep:externalId without adding the corresponding mixin type");
        authorizable.setProperty(REP_EXTERNAL_ID, this.valueFactory.createValue(externalIdentity.getExternalId().getString()));
    }

    @NotNull
    protected DefaultSyncResultImpl syncUser(@NotNull ExternalUser external, @NotNull User user) throws RepositoryException {
        SyncResult.Status status;
        if (!this.isSameIDP(user)) {
            return new DefaultSyncResultImpl(new DefaultSyncedIdentity(external.getId(), external.getExternalId(), false, -1L), SyncResult.Status.FOREIGN);
        }
        if (!this.forceUserSync && !this.isExpired(user)) {
            status = SyncResult.Status.NOP;
        } else {
            this.syncExternalIdentity(external, user, this.config.user());
            if (this.isExpired(user, this.config.user().getMembershipExpirationTime(), "Membership")) {
                this.syncMembership(external, user, this.config.user().getMembershipNestingDepth());
            }
            if (this.config.user().getDisableMissing() && user.isDisabled()) {
                status = SyncResult.Status.ENABLE;
                user.disable(null);
            } else {
                status = SyncResult.Status.UPDATE;
            }
            user.setProperty(REP_LAST_SYNCED, this.nowValue);
        }
        return new DefaultSyncResultImpl(DefaultSyncContext.createSyncedIdentity(user), status);
    }

    @NotNull
    protected DefaultSyncResultImpl syncGroup(@NotNull ExternalGroup external, @NotNull Group group) throws RepositoryException {
        SyncResult.Status status;
        if (!this.isSameIDP(group)) {
            return new DefaultSyncResultImpl(new DefaultSyncedIdentity(external.getId(), external.getExternalId(), false, -1L), SyncResult.Status.FOREIGN);
        }
        if (!this.forceGroupSync && !this.isExpired(group)) {
            status = SyncResult.Status.NOP;
        } else {
            this.syncExternalIdentity(external, group, this.config.group());
            group.setProperty(REP_LAST_SYNCED, this.nowValue);
            status = SyncResult.Status.UPDATE;
        }
        return new DefaultSyncResultImpl(DefaultSyncContext.createSyncedIdentity(group), status);
    }

    private void syncExternalIdentity(@NotNull ExternalIdentity external, @NotNull Authorizable authorizable, @NotNull DefaultSyncConfig.Authorizable config) throws RepositoryException {
        this.syncProperties(external, authorizable, config.getPropertyMapping());
        this.applyMembership(authorizable, config.getAutoMembership(authorizable));
    }

    protected void syncMembership(@NotNull ExternalIdentity external, @NotNull Authorizable auth, long depth) throws RepositoryException {
        Iterable<ExternalIdentityRef> externalGroups;
        if (depth <= 0L) {
            return;
        }
        log.debug("Syncing membership '{}' -> '{}'", (Object)external.getExternalId().getString(), (Object)auth.getID());
        DebugTimer timer = new DebugTimer();
        try {
            externalGroups = external.getDeclaredGroups();
        }
        catch (ExternalIdentityException e) {
            log.error("Error while retrieving external declared groups for '{}'", (Object)external.getId(), (Object)e);
            return;
        }
        timer.mark("fetching");
        HashMap<String, Group> declaredExternalGroups = new HashMap<String, Group>();
        Iterator<Group> grpIter = auth.declaredMemberOf();
        while (grpIter.hasNext()) {
            Group grp = grpIter.next();
            if (!this.isSameIDP(grp)) continue;
            declaredExternalGroups.put(grp.getID(), grp);
        }
        timer.mark("reading");
        for (ExternalIdentityRef ref : externalGroups) {
            boolean exists;
            ExternalGroup extGroup;
            block16: {
                log.debug("- processing membership {}", (Object)ref.getId());
                try {
                    ExternalIdentity extId = this.idp.getIdentity(ref);
                    if (extId instanceof ExternalGroup) {
                        extGroup = (ExternalGroup)extId;
                        break block16;
                    }
                    log.warn("No external group found for ref '{}'.", (Object)ref.getString());
                }
                catch (ExternalIdentityException e) {
                    log.warn("Unable to retrieve external group '{}' from provider.", (Object)ref.getString(), (Object)e);
                }
                continue;
            }
            log.debug("- idp returned '{}'", (Object)extGroup.getId());
            Group grp = (Group)declaredExternalGroups.remove(extGroup.getId());
            boolean bl = exists = grp != null;
            if (!exists) {
                Authorizable a = this.userManager.getAuthorizable(extGroup.getId());
                if (a == null) {
                    grp = this.createGroup(extGroup);
                    log.debug("- created new group");
                } else if (a.isGroup() && this.isSameIDP(a)) {
                    grp = (Group)a;
                } else {
                    log.warn("Existing authorizable '{}' is not a group from this IDP '{}'.", (Object)extGroup.getId(), (Object)this.idp.getName());
                    continue;
                }
                log.debug("- user manager returned '{}'", (Object)grp);
            }
            this.syncGroup(extGroup, grp);
            if (!exists) {
                grp.addMember(auth);
                log.debug("- added '{}' as member to '{}'", (Object)auth, (Object)grp);
            }
            if (depth > 1L) {
                log.debug("- recursively sync group membership of '{}' (depth = {}).", (Object)grp.getID(), (Object)depth);
                this.syncMembership(extGroup, grp, depth - 1L);
                continue;
            }
            log.debug("- group nesting level for '{}' reached", (Object)grp.getID());
        }
        timer.mark("adding");
        for (Group grp : declaredExternalGroups.values()) {
            grp.removeMember(auth);
            log.debug("- removing member '{}' for group '{}'", (Object)auth.getID(), (Object)grp.getID());
        }
        timer.mark("removing");
        log.debug("syncMembership({}) {}", (Object)external.getId(), (Object)timer);
    }

    protected void applyMembership(@NotNull Authorizable member, @NotNull Set<String> groups) throws RepositoryException {
        for (String groupName : groups) {
            Authorizable group = this.userManager.getAuthorizable(groupName);
            if (group == null) {
                log.warn("Unable to apply auto-membership to {}. No such group: {}", (Object)member.getID(), (Object)groupName);
                continue;
            }
            if (group instanceof Group) {
                ((Group)group).addMember(member);
                continue;
            }
            log.warn("Unable to apply auto-membership to {}. Authorizable '{}' is not a group.", (Object)member.getID(), (Object)groupName);
        }
    }

    protected void syncProperties(@NotNull ExternalIdentity ext, @NotNull Authorizable auth, @NotNull Map<String, String> mapping) throws RepositoryException {
        Map<String, ?> properties = ext.getProperties();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            String relPath = entry.getKey();
            String name = entry.getValue();
            Object obj = properties.get(name);
            if (obj == null) {
                int nameLen = name.length();
                if (nameLen > 1 && name.charAt(0) == '\"' && name.charAt(nameLen - 1) == '\"') {
                    auth.setProperty(relPath, this.valueFactory.createValue(name.substring(1, nameLen - 1)));
                    continue;
                }
                auth.removeProperty(relPath);
                continue;
            }
            if (obj instanceof Collection) {
                auth.setProperty(relPath, this.createValues((Collection)obj));
                continue;
            }
            if (obj instanceof byte[] || obj instanceof char[]) {
                auth.setProperty(relPath, this.createValue(obj));
                continue;
            }
            if (obj instanceof Object[]) {
                auth.setProperty(relPath, this.createValues(Arrays.asList((Object[])obj)));
                continue;
            }
            auth.setProperty(relPath, this.createValue(obj));
        }
    }

    private boolean isExpired(@NotNull Authorizable authorizable) throws RepositoryException {
        long expTime = authorizable.isGroup() ? this.config.group().getExpirationTime() : this.config.user().getExpirationTime();
        return this.isExpired(authorizable, expTime, "Properties");
    }

    protected boolean isExpired(@NotNull Authorizable auth, long expirationTime, @NotNull String type) throws RepositoryException {
        Value[] values = auth.getProperty(REP_LAST_SYNCED);
        if (values == null || values.length == 0) {
            log.debug("{} of {} '{}' need sync. {} not set.", type, DefaultSyncContext.authType(auth), auth.getID(), REP_LAST_SYNCED);
            return true;
        }
        if (this.now - values[0].getLong() > expirationTime) {
            log.debug("{} of {} '{}' need sync. {} expired ({} > {})", type, DefaultSyncContext.authType(auth), auth.getID(), this.now - values[0].getLong(), expirationTime, REP_LAST_SYNCED);
            return true;
        }
        log.debug("{} of {} '{}' do not need sync.", type, DefaultSyncContext.authType(auth), auth.getID());
        return false;
    }

    @Nullable
    protected Value createValue(@Nullable Object v) throws RepositoryException {
        if (v == null) {
            return null;
        }
        if (v instanceof Boolean) {
            return this.valueFactory.createValue((Boolean)v);
        }
        if (v instanceof Byte || v instanceof Short || v instanceof Integer || v instanceof Long) {
            return this.valueFactory.createValue(((Number)v).longValue());
        }
        if (v instanceof Float || v instanceof Double) {
            return this.valueFactory.createValue(((Number)v).doubleValue());
        }
        if (v instanceof BigDecimal) {
            return this.valueFactory.createValue((BigDecimal)v);
        }
        if (v instanceof Calendar) {
            return this.valueFactory.createValue((Calendar)v);
        }
        if (v instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)v);
            return this.valueFactory.createValue(cal);
        }
        if (v instanceof byte[]) {
            Binary bin = this.valueFactory.createBinary(new ByteArrayInputStream((byte[])v));
            return this.valueFactory.createValue(bin);
        }
        if (v instanceof Binary) {
            return this.valueFactory.createValue((Binary)v);
        }
        if (v instanceof InputStream) {
            return this.valueFactory.createValue((InputStream)v);
        }
        if (v instanceof char[]) {
            return this.valueFactory.createValue(new String((char[])v));
        }
        return this.valueFactory.createValue(String.valueOf(v));
    }

    @Nullable
    protected Value[] createValues(@NotNull Collection<?> propValues) throws RepositoryException {
        ArrayList<Value> values = new ArrayList<Value>();
        for (Object obj : propValues) {
            Value v = this.createValue(obj);
            if (v == null) continue;
            values.add(v);
        }
        return values.toArray(new Value[0]);
    }

    protected boolean isSameIDP(@Nullable Authorizable auth) throws RepositoryException {
        ExternalIdentityRef ref = DefaultSyncContext.getIdentityRef(auth);
        return ref != null && this.idp.getName().equals(ref.getProviderName());
    }

    protected boolean isSameIDP(@NotNull ExternalIdentityRef ref) {
        return this.idp.getName().equals(ref.getProviderName());
    }

    private static String authType(@NotNull Authorizable a) {
        return a.isGroup() ? "group" : "user";
    }
}

