/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.Dumpable;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.PathMapping;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.fs.spi.ProgressTracker;
import org.apache.jackrabbit.vault.util.RejectingEntityResolver;
import org.apache.jackrabbit.vault.util.Tree;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DefaultWorkspaceFilter
implements Dumpable,
WorkspaceFilter {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkspaceFilter.class);
    private final List<PathFilterSet> nodesFilterSets = new LinkedList<PathFilterSet>();
    private final List<PathFilterSet> propsFilterSets = new LinkedList<PathFilterSet>();
    private List<PathFilterSet> referenceFilterSets = null;
    public static final String ATTR_VERSION = "version";
    public static final double SUPPORTED_VERSION = 1.0;
    protected double version = 1.0;
    private byte[] source;
    private PathFilter globalIgnored;
    private ImportMode importMode;

    public void add(PathFilterSet set) {
        this.nodesFilterSets.add(set);
        if (this.referenceFilterSets == null) {
            this.referenceFilterSets = new LinkedList<PathFilterSet>();
        }
        this.referenceFilterSets.add(set);
        for (PathFilterSet s : this.propsFilterSets) {
            if (!s.getRoot().equals(set.getRoot())) continue;
            return;
        }
        this.propsFilterSets.add(new PathFilterSet(set.getRoot()));
    }

    public void add(PathFilterSet nodeFilter, PathFilterSet propFilter) {
        if (!nodeFilter.getRoot().equals(propFilter.getRoot())) {
            throw new IllegalArgumentException("Adding node and property filter sets must have the same root");
        }
        this.nodesFilterSets.add(nodeFilter);
        this.propsFilterSets.add(propFilter);
        if (this.referenceFilterSets == null) {
            this.referenceFilterSets = new LinkedList<PathFilterSet>();
        }
        PathFilterSet bothFilter = new PathFilterSet(nodeFilter.getRoot());
        bothFilter.setType(nodeFilter.getType());
        bothFilter.setImportMode(nodeFilter.getImportMode());
        bothFilter.addAll(nodeFilter);
        for (FilterSet.Entry entry : propFilter.getEntries()) {
            PathFilter filter = (PathFilter)entry.getFilter();
            if (filter instanceof DefaultPathFilter) {
                if (entry.isInclude()) {
                    bothFilter.addInclude(new DefaultPropertyPathFilter(((DefaultPathFilter)filter).getPattern()));
                    continue;
                }
                bothFilter.addExclude(new DefaultPropertyPathFilter(((DefaultPathFilter)filter).getPattern()));
                continue;
            }
            throw new IllegalArgumentException("Can only export default path filters, yet.");
        }
        this.referenceFilterSets.add(bothFilter);
    }

    @Deprecated
    public void addPropertyFilterSet(PathFilterSet set) {
        Iterator<PathFilterSet> iter = this.propsFilterSets.iterator();
        while (iter.hasNext()) {
            PathFilterSet filterSet = iter.next();
            if (!filterSet.getRoot().equals(set.getRoot())) continue;
            iter.remove();
            break;
        }
        this.propsFilterSets.add(set);
    }

    @Override
    public List<PathFilterSet> getFilterSets() {
        return this.nodesFilterSets;
    }

    @Override
    public List<PathFilterSet> getPropertyFilterSets() {
        return this.propsFilterSets;
    }

    @Override
    public PathFilterSet getCoveringFilterSet(String path) {
        if (this.isGloballyIgnored(path)) {
            return null;
        }
        for (PathFilterSet set : this.nodesFilterSets) {
            if (!set.covers(path)) continue;
            return set;
        }
        return null;
    }

    @Override
    public ImportMode getImportMode(String path) {
        if (this.importMode != null) {
            return this.importMode;
        }
        PathFilterSet set = this.getCoveringFilterSet(path);
        return set == null ? ImportMode.REPLACE : set.getImportMode();
    }

    public void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    @Override
    public boolean contains(String path) {
        if (this.isGloballyIgnored(path)) {
            return false;
        }
        for (PathFilterSet set : this.nodesFilterSets) {
            if (!set.contains(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean covers(String path) {
        if (this.isGloballyIgnored(path)) {
            return false;
        }
        for (PathFilterSet set : this.nodesFilterSets) {
            if (!set.covers(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAncestor(String path) {
        for (PathFilterSet set : this.nodesFilterSets) {
            if (!set.isAncestor(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGloballyIgnored(String path) {
        return this.globalIgnored != null && this.globalIgnored.matches(path);
    }

    @Override
    public WorkspaceFilter translate(PathMapping mapping) {
        if (mapping == null) {
            return this;
        }
        DefaultWorkspaceFilter mapped = new DefaultWorkspaceFilter();
        mapped.importMode = this.importMode;
        if (this.globalIgnored != null) {
            mapped.setGlobalIgnored(this.globalIgnored.translate(mapping));
        }
        for (PathFilterSet set : this.nodesFilterSets) {
            mapped.nodesFilterSets.add(set.translate(mapping));
        }
        for (PathFilterSet set : this.propsFilterSets) {
            mapped.propsFilterSets.add(set.translate(mapping));
        }
        return mapped;
    }

    public void load(File file) throws IOException, ConfigurationException {
        try (FileInputStream input = new FileInputStream(file);){
            this.load(input);
        }
    }

    @Override
    public InputStream getSource() {
        if (this.source == null) {
            this.generateSource();
        }
        return new ByteArrayInputStream(this.source);
    }

    @Override
    public String getSourceAsString() {
        if (this.source == null) {
            this.generateSource();
        }
        try {
            return new String(this.source, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void load(InputStream in) throws IOException, ConfigurationException {
        this.source = IOUtils.toByteArray(in);
        try (InputStream inCopy = this.getSource();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new RejectingEntityResolver());
            Document document = builder.parse(inCopy);
            Element doc = document.getDocumentElement();
            this.load(doc);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Unable to create configuration XML parser", e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Configuration file syntax error.", e);
        }
    }

    public void load(Element doc) throws ConfigurationException {
        if (!"workspaceFilter".equals(doc.getNodeName())) {
            throw new ConfigurationException("<workspaceFilter> expected.");
        }
        String v = doc.getAttribute(ATTR_VERSION);
        if (v == null || "".equals(v)) {
            v = "1.0";
        }
        this.version = Double.parseDouble(v);
        if (this.version > 1.0) {
            throw new ConfigurationException("version " + this.version + " not supported.");
        }
        this.nodesFilterSets.clear();
        this.propsFilterSets.clear();
        this.referenceFilterSets = new LinkedList<PathFilterSet>();
        this.read(doc);
    }

    private void read(Element elem) throws ConfigurationException {
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            org.w3c.dom.Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (!"filter".equals(child.getNodeName())) {
                throw new ConfigurationException("<filter> expected.");
            }
            this.readDef((Element)child);
        }
    }

    private void readDef(Element elem) throws ConfigurationException {
        String type;
        String root = elem.getAttribute("root");
        if (root == null || root.length() == 0) {
            root = "/";
        }
        PathFilterSet nodeFilters = new PathFilterSet(root);
        PathFilterSet propFilters = new PathFilterSet(root);
        PathFilterSet bothFilters = new PathFilterSet(root);
        String mode = elem.getAttribute("mode");
        if (mode != null && mode.length() > 0) {
            ImportMode importMode = ImportMode.valueOf(mode.toUpperCase());
            nodeFilters.setImportMode(importMode);
            propFilters.setImportMode(importMode);
            bothFilters.setImportMode(importMode);
        }
        if ((type = elem.getAttribute("type")) != null && type.length() > 0) {
            nodeFilters.setType(type);
            propFilters.setType(type);
            bothFilters.setType(type);
        }
        NodeList n1 = elem.getChildNodes();
        for (int i = 0; i < n1.getLength(); ++i) {
            org.w3c.dom.Node child = n1.item(i);
            if (child.getNodeType() != 1) continue;
            PathFilter filter = this.readFilter((Element)child);
            if ("include".equals(child.getNodeName())) {
                if (filter instanceof DefaultPropertyPathFilter) {
                    propFilters.addInclude(filter);
                } else {
                    nodeFilters.addInclude(filter);
                }
                bothFilters.addInclude(filter);
                continue;
            }
            if ("exclude".equals(child.getNodeName())) {
                if (filter instanceof DefaultPropertyPathFilter) {
                    propFilters.addExclude(filter);
                } else {
                    nodeFilters.addExclude(filter);
                }
                bothFilters.addExclude(filter);
                continue;
            }
            throw new ConfigurationException("either <include> or <exclude> expected.");
        }
        this.nodesFilterSets.add(nodeFilters);
        this.propsFilterSets.add(propFilters);
        this.referenceFilterSets.add(bothFilters);
    }

    protected PathFilter readFilter(Element elem) throws ConfigurationException {
        String pattern = elem.getAttribute("pattern");
        if (pattern == null || "".equals(pattern)) {
            throw new ConfigurationException("Filter pattern must not be empty");
        }
        boolean matchProperties = Boolean.valueOf(elem.getAttribute("matchProperties"));
        if (matchProperties) {
            return new DefaultPropertyPathFilter(pattern);
        }
        return new DefaultPathFilter(pattern);
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        Iterator<PathFilterSet> iter = this.nodesFilterSets.iterator();
        while (iter.hasNext()) {
            PathFilterSet set = iter.next();
            ctx.println(!iter.hasNext(), "ItemFilterSet");
            ctx.indent(!iter.hasNext());
            set.dump(ctx, false);
            ctx.outdent();
        }
    }

    public void resetSource() {
        this.source = null;
    }

    private void generateSource() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLSerializer ser = new XMLSerializer((OutputStream)out, new OutputFormat("xml", "UTF-8", true));
            ser.startDocument();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, ATTR_VERSION, "CDATA", String.valueOf(this.version));
            ser.startElement(null, null, "workspaceFilter", (Attributes)attrs);
            if (this.referenceFilterSets == null) {
                this.referenceFilterSets = new LinkedList<PathFilterSet>(this.nodesFilterSets);
            }
            for (PathFilterSet set : this.referenceFilterSets) {
                attrs = new AttributesImpl();
                attrs.addAttribute(null, null, "root", "CDATA", set.getRoot());
                if (set.getImportMode() != ImportMode.REPLACE) {
                    attrs.addAttribute(null, null, "mode", "CDATA", set.getImportMode().name().toLowerCase());
                }
                if (set.getType() != null) {
                    attrs.addAttribute(null, null, "type", "CDATA", set.getType());
                }
                ser.startElement(null, null, "filter", (Attributes)attrs);
                for (FilterSet.Entry entry : set.getEntries()) {
                    PathFilter filter = (PathFilter)entry.getFilter();
                    if (filter instanceof DefaultPathFilter) {
                        attrs = new AttributesImpl();
                        attrs.addAttribute(null, null, "pattern", "CDATA", ((DefaultPathFilter)filter).getPattern());
                        if (filter instanceof DefaultPropertyPathFilter) {
                            attrs.addAttribute(null, null, "matchProperties", "CDATA", "true");
                        }
                        if (entry.isInclude()) {
                            ser.startElement(null, null, "include", (Attributes)attrs);
                            ser.endElement("include");
                            continue;
                        }
                        ser.startElement(null, null, "exclude", (Attributes)attrs);
                        ser.endElement("exclude");
                        continue;
                    }
                    throw new IllegalArgumentException("Can only export default path filters, yet.");
                }
                ser.endElement("filter");
            }
            ser.endElement("workspaceFilter");
            ser.endDocument();
            this.source = out.toByteArray();
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setGlobalIgnored(PathFilter ignored) {
        this.globalIgnored = ignored;
    }

    @Override
    public void dumpCoverage(Node rootNode, ProgressTrackerListener listener) throws RepositoryException {
        ProgressTracker tracker = new ProgressTracker(listener);
        log.debug("Starting coverage dump at / (skipJcrContent=false)");
        this.dumpCoverage(rootNode, tracker, false);
    }

    @Override
    public void dumpCoverage(Session session, ProgressTrackerListener listener, boolean skipJcrContent) throws RepositoryException {
        Node rootNode;
        ProgressTracker tracker = new ProgressTracker(listener);
        Tree<PathFilterSet> tree = new Tree<PathFilterSet>();
        for (PathFilterSet set : this.nodesFilterSets) {
            tree.put(set.getRoot(), set);
        }
        String rootPath = tree.getRootPath();
        if (session.nodeExists(rootPath)) {
            rootNode = session.getNode(rootPath);
        } else if (session.nodeExists("/")) {
            log.warn("Common ancestor {} not found. Using root node", (Object)rootPath);
            rootNode = session.getRootNode();
            rootPath = "/";
        } else {
            throw new PathNotFoundException("Common ancestor " + rootPath + " not found.");
        }
        log.debug("Starting coverage dump at {} (skipJcrContent={})", (Object)rootPath, (Object)skipJcrContent);
        this.dumpCoverage(rootNode, tracker, skipJcrContent);
    }

    private void dumpCoverage(Node node, ProgressTracker tracker, boolean skipJcrContent) throws RepositoryException {
        String path = node.getPath();
        if (skipJcrContent && "jcr:content".equals(Text.getName(path))) {
            return;
        }
        boolean contained = this.contains(path);
        if (contained || this.isAncestor(path)) {
            if (contained) {
                tracker.track("A", path);
            }
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                this.dumpCoverage(iter.nextNode(), tracker, skipJcrContent);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.globalIgnored == null ? 0 : this.globalIgnored.hashCode());
        result = 31 * result + (this.importMode == null ? 0 : this.importMode.hashCode());
        result = 31 * result + (this.nodesFilterSets == null ? 0 : this.nodesFilterSets.hashCode());
        result = 31 * result + (this.propsFilterSets == null ? 0 : this.propsFilterSets.hashCode());
        result = 31 * result + (this.referenceFilterSets == null ? 0 : this.referenceFilterSets.hashCode());
        long temp = Double.doubleToLongBits(this.version);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultWorkspaceFilter other = (DefaultWorkspaceFilter)obj;
        if (this.globalIgnored == null ? other.globalIgnored != null : !this.globalIgnored.equals(other.globalIgnored)) {
            return false;
        }
        if (this.importMode != other.importMode) {
            return false;
        }
        if (this.nodesFilterSets == null ? other.nodesFilterSets != null : !this.nodesFilterSets.equals(other.nodesFilterSets)) {
            return false;
        }
        if (this.propsFilterSets == null ? other.propsFilterSets != null : !this.propsFilterSets.equals(other.propsFilterSets)) {
            return false;
        }
        if (this.referenceFilterSets == null ? other.referenceFilterSets != null : !this.referenceFilterSets.equals(other.referenceFilterSets)) {
            return false;
        }
        return Double.doubleToLongBits(this.version) == Double.doubleToLongBits(other.version);
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        this.dump(new DumpContext(new PrintWriter(stringWriter)), true);
        return stringWriter.toString();
    }

    private static class DefaultPropertyPathFilter
    extends DefaultPathFilter {
        private DefaultPropertyPathFilter(String pattern) {
            super(pattern);
        }

        @Override
        public PathFilter translate(PathMapping mapping) {
            DefaultPathFilter mapped = (DefaultPathFilter)super.translate(mapping);
            if (mapped != this) {
                mapped = new DefaultPropertyPathFilter(mapped.getPattern());
            }
            return mapped;
        }
    }
}

