/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.StatusCode;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;

@Deprecated(since="2021-05-27")
public class CloseInfo {
    private int statusCode = 0;
    private byte[] reasonBytes;

    public CloseInfo() {
        this(1005, null);
    }

    public CloseInfo(ByteBuffer payload, boolean validate) {
        this.statusCode = 1005;
        if (payload == null || payload.remaining() == 0) {
            return;
        }
        ByteBuffer data = payload.slice();
        if (data.remaining() == 1 && validate) {
            throw new ProtocolException("Invalid 1 byte payload");
        }
        if (data.remaining() >= 2) {
            this.statusCode = 0;
            this.statusCode |= (data.get() & 0xFF) << 8;
            this.statusCode |= data.get() & 0xFF;
            if (validate) {
                this.assertValidStatusCode(this.statusCode);
            }
            if (data.remaining() > 0) {
                int len = Math.min(data.remaining(), 123);
                this.reasonBytes = new byte[len];
                data.get(this.reasonBytes, 0, len);
                if (validate) {
                    try {
                        Utf8StringBuilder utf = new Utf8StringBuilder();
                        utf.append(this.reasonBytes, 0, this.reasonBytes.length);
                    }
                    catch (Utf8Appendable.NotUtf8Exception e) {
                        throw new BadPayloadException("Invalid Close Reason", (Throwable)e);
                    }
                }
            }
        }
    }

    public CloseInfo(Frame frame) {
        this(frame.getPayload(), false);
    }

    public CloseInfo(Frame frame, boolean validate) {
        this(frame.getPayload(), validate);
    }

    public CloseInfo(int statusCode) {
        this(statusCode, null);
    }

    public CloseInfo(int statusCode, String reason) {
        this.statusCode = statusCode;
        if (reason != null) {
            byte[] utf8Bytes = reason.getBytes(StandardCharsets.UTF_8);
            if (utf8Bytes.length > 123) {
                this.reasonBytes = new byte[123];
                System.arraycopy(utf8Bytes, 0, this.reasonBytes, 0, 123);
            } else {
                this.reasonBytes = utf8Bytes;
            }
        }
    }

    private void assertValidStatusCode(int statusCode) {
        if (statusCode <= 999 || statusCode >= 5000) {
            throw new ProtocolException("Out of range close status code: " + statusCode);
        }
        if (statusCode == 1006 || statusCode == 1005 || statusCode == 1015) {
            throw new ProtocolException("Frame forbidden close status code: " + statusCode);
        }
        if (statusCode >= 1000 && statusCode <= 2999 && !StatusCode.isTransmittable(statusCode)) {
            throw new ProtocolException("RFC6455 and IANA Undefined close status code: " + statusCode);
        }
    }

    private ByteBuffer asByteBuffer() {
        boolean hasReason;
        if (this.statusCode == 1006 || this.statusCode == 1005 || this.statusCode == -1) {
            return null;
        }
        int len = 2;
        boolean bl = hasReason = this.reasonBytes != null && this.reasonBytes.length > 0;
        if (hasReason) {
            len += this.reasonBytes.length;
        }
        ByteBuffer buf = BufferUtil.allocate(len);
        BufferUtil.flipToFill(buf);
        buf.put((byte)(this.statusCode >>> 8 & 0xFF));
        buf.put((byte)(this.statusCode >>> 0 & 0xFF));
        if (hasReason) {
            buf.put(this.reasonBytes, 0, this.reasonBytes.length);
        }
        BufferUtil.flipToFlush(buf, 0);
        return buf;
    }

    public CloseFrame asFrame() {
        CloseFrame frame = new CloseFrame();
        frame.setFin(true);
        if (this.statusCode != 1006 && this.statusCode != 1005 && this.statusCode != 1015) {
            this.assertValidStatusCode(this.statusCode);
            frame.setPayload(this.asByteBuffer());
        }
        return frame;
    }

    public String getReason() {
        if (this.reasonBytes == null) {
            return null;
        }
        return new String(this.reasonBytes, StandardCharsets.UTF_8);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isHarsh() {
        return this.statusCode != 1000 && this.statusCode != 1005;
    }

    public boolean isAbnormal() {
        return this.statusCode != 1000;
    }

    public String toString() {
        return String.format("CloseInfo[code=%d,reason=%s]", this.statusCode, this.getReason());
    }
}

