/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated(since="2021-05-27")
class ReadState {
    private static final Logger LOG = Log.getLogger(ReadState.class);
    private State state = State.READING;
    private ByteBuffer buffer;

    ReadState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getBuffer() {
        ReadState readState = this;
        synchronized (readState) {
            return this.buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReading() {
        ReadState readState = this;
        synchronized (readState) {
            return this.state == State.READING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSuspended() {
        ReadState readState = this;
        synchronized (readState) {
            return this.state == State.SUSPENDED || this.state == State.EOF;
        }
    }

    Action getAction(ByteBuffer buffer) {
        ReadState readState = this;
        synchronized (readState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} getAction({})", this, BufferUtil.toDetailString(buffer));
            }
            switch (this.state) {
                case READING: {
                    return buffer.hasRemaining() ? Action.PARSE : Action.FILL;
                }
                case SUSPENDING: {
                    this.buffer = buffer;
                    this.state = State.SUSPENDED;
                    return Action.SUSPEND;
                }
                case EOF: {
                    return Action.EOF;
                }
                case DISCARDING: {
                    return buffer.hasRemaining() ? Action.DISCARD : Action.FILL;
                }
            }
            throw new IllegalStateException(this.toString(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspending() {
        ReadState readState = this;
        synchronized (readState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("suspending {}", new Object[]{this.state});
            }
            switch (this.state) {
                case READING: {
                    this.state = State.SUSPENDING;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString(this.state));
                }
            }
        }
    }

    ByteBuffer resume() {
        ReadState readState = this;
        synchronized (readState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("resuming {}", new Object[]{this.state});
            }
            switch (this.state) {
                case SUSPENDING: {
                    this.state = State.READING;
                    return null;
                }
                case SUSPENDED: {
                    this.state = State.READING;
                    ByteBuffer bb = this.buffer;
                    this.buffer = null;
                    return bb;
                }
            }
            throw new IllegalStateException(this.toString(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void eof() {
        ReadState readState = this;
        synchronized (readState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("eof {}", new Object[]{this.state});
            }
            this.state = State.EOF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discard() {
        ReadState readState = this;
        synchronized (readState) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("discard {}", new Object[]{this.state});
            }
            switch (this.state) {
                case READING: 
                case SUSPENDING: 
                case SUSPENDED: {
                    this.state = State.DISCARDING;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.toString(this.state));
                }
            }
        }
    }

    private String toString(State state) {
        return String.format("%s@%x[%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), state});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ReadState readState = this;
        synchronized (readState) {
            return this.toString(this.state);
        }
    }

    @Deprecated(since="2021-05-27")
    private static enum State {
        READING,
        SUSPENDING,
        SUSPENDED,
        DISCARDING,
        EOF;

    }

    @Deprecated(since="2021-05-27")
    static enum Action {
        FILL,
        PARSE,
        DISCARD,
        SUSPEND,
        EOF;

    }
}

