/*
*
*	File: UnsupportedFontException.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font;


/** Generally thrown when the major version number of a table is not
 *  supported or when the font contains unsupported operators that make
 *  it unusable.
 *  
 * <h4>Synchronization</h4>
 * 
 * <p>This class has the same threadsafety guarantees java.lang.Exception.</p>
 *
 **/

public class UnsupportedFontException extends FontException {
  
    static final long serialVersionUID = 1;

    public UnsupportedFontException () {
      super ();
    }

    public UnsupportedFontException (Font font) {
      super (font);
    }

    public UnsupportedFontException (String message) {
      super (message);
    }

    public UnsupportedFontException (String message, Font font) {
      super (message, font);
    }

    public UnsupportedFontException (String message, Throwable cause) {
        super (message, cause);
    }

    public UnsupportedFontException (String message, Throwable cause, Font font) {
        super (message, cause, font);
    }

    public UnsupportedFontException (Throwable cause) {
        super (cause);
    }

    public UnsupportedFontException (Throwable cause, Font font) {
        super (cause, font);
    }
}