/*
*
*	File: CharStrings.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
*/

package com.adobe.fontengine.font.cff;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.cff.CFFByteArray.CFFByteArrayBuilder;

/** Represents a CharstringINDEX. 
 */
final public class CharStrings extends Index {

  /* We inherit our strategy from our superclass. */
  
  /** Construct a <code>CharStrings</code> from a <code>CFFByteArray</code>.
   * @param data the CFFByteArray to get data from
   * @param offset the offset of the first byte in <code>data</code>
   */
  protected CharStrings (CFFByteArray data, int offset) 
  throws InvalidFontException, UnsupportedFontException {
    super (data, offset);
  }
  
  static protected CharStrings createEmptyCharstrings()
  throws InvalidFontException, UnsupportedFontException {
    byte[] data = new byte[2];
    data[0] = data[1] = 0;

    CFFByteArrayBuilder builder = CFFByteArray.getCFFByteArrayBuilderInstance(2);
    builder.addCard16(0);
    return new CharStrings(builder.toCFFByteArray(), 0);
  }
}
