/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.granite.haf.converter.api;

import java.util.List;
import java.util.Map;

import com.adobe.granite.haf.api.OrderByDetails;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.request.RequestPathInfo;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/**
 * A context object providing useful information from the request. Can be adapted to ResourceConverterContext.
 */
@ProviderType
public interface ConverterContext extends Adaptable {
    /**
     * Default page size limit.
     */
    int DEFAULT_LIMIT = 20;
    /**
     * Default indicator if absolute URIs should be used.
     */
    boolean DEFAULT_USE_ABSOLUTE_URIS = true;

    /**
     * Get the Root Context Path Value as defined in OSGI config for ApiEndpointResourceProviderFactory
     * @return The root context path.
     */
    @CheckForNull
    String getRootContextPath();

    /**
     * Returns the limit.
     * @return The limit value
     */
    int getLimit();

    /**
     * Returns the name of the scheme.
     * @return Scheme name
     */
    @CheckForNull
    String getScheme();

    /**
     * Returns the host name of the server.
     * @return Server host name
     */
    @CheckForNull
    String getServerName();

    /**
     * Returns the port number.
     * @return Server port
     */
    int getServerPort();

    /**
     * Returns the portion of the request URI that indicates the context.
     * @return Context path
     */
    @CheckForNull
    String getContextPath();

    /**
     * Returns the {@link org.apache.sling.api.request.RequestPathInfo}.
     * @return RequestPathInfo
     */
    @CheckForNull
    RequestPathInfo getRequestPathInfo();

    /**
     * Returns the request parameters.
     * @return A {@link java.util.Map} of request parameter keys and values
     */
    @CheckForNull
    Map<String, String[]> getParameters();

    /**
     * Returns the query.
     * @return Query value
     */
    @CheckForNull
    String getQuery();

    /**
     * Indicator if absolute URI's are used.
     * @return {@code true} if URIs are absolute, {@code false} otherwise
     */
    boolean isAbsoluteURI();

    /**
     * Retrieves the filters to be applied by the model when getting entities.
     * @return The filters the model must use.
     */
    @Nonnull
    Map<String, String[]> getModelFilters();

    /**
     * Returns the media type that was matched from the request and that the converter is being asked to provide.
     * @return The matched media type
     */
    @CheckForNull
    String getMatchedMediaType();

    /**
     * Set the media type that was matched from the request and the converter is being asked to provide.
     * @param mediaType The matched media type
     */
    void setMatchedMediaType(String mediaType);

    /**
     * Returns the HTTP method of the request.
     * @return The HTTP method of the request
     */
    @CheckForNull
    String getRequestMethod();

    /**
     * Set the offset value. Pagination could assign this value to a number or a string depending on the design of the
     * URL space.
     * @param value the value of the url parameter
     * @return the current context
     */
    ConverterContext setOffsetValue(String value);

    /**
     * Get this converters current offset value or the offset if that has been set.
     * @return the offset value
     */
    String getOffsetValue();

    /**
     * Get this converters current list of order by information.
     * @return the list of requested order by details or an empty list if nothing was specified
     */
    @CheckForNull
    List<OrderByDetails> getOrderBy();
}
